/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

public abstract class Buffer {
    int capacity;
    int limit;
    int position;

    Buffer() {
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final Buffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.capacity) {
            throw new IllegalArgumentException();
        }
        if (this.position > newLimit) {
            this.position = newLimit;
        }
        this.limit = newLimit;
        return this;
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }
}

