/*
 * Decompiled with CFR 0.152.
 */
package ru.woesss.j2me.micro3d;

import emulator.custom.ResourceManager;
import java.io.IOException;
import ru.woesss.j2me.micro3d.Action;
import ru.woesss.j2me.micro3d.Loader;
import ru.woesss.j2me.micro3d.SparseIntArray;

public class ActTableImpl {
    Action[] actions;

    public ActTableImpl(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            this.actions = Loader.loadMtraData(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.err.println("Error loading data");
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public ActTableImpl(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            this.actions = Loader.loadMtraData(byArray, n2, n3);
        }
        catch (Exception exception) {
            System.err.println("Error loading data");
            exception.printStackTrace();
            throw exception;
        }
    }

    public ActTableImpl(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        byte[] byArray = ResourceManager.getBytes(string);
        if (byArray == null) {
            throw new IOException();
        }
        try {
            this.actions = Loader.loadMtraData(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.err.println("Error loading data from [" + string + "]");
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    public final void dispose() {
        this.actions = null;
    }

    public final int getNumActions() {
        this.checkDisposed();
        return this.actions.length;
    }

    public final int getNumFrames(int n2) {
        this.checkDisposed();
        if (n2 < 0 || n2 >= this.actions.length) {
            throw new IllegalArgumentException();
        }
        return this.actions[n2].keyframes << 16;
    }

    private void checkDisposed() {
        if (this.actions == null) {
            throw new IllegalStateException("ActionTable disposed!");
        }
    }

    public int getPattern(int n2, int n3, int n4) {
        Action action = this.actions[n2];
        SparseIntArray sparseIntArray = action.dynamic;
        if (sparseIntArray != null) {
            int n5 = n3 < 0 ? 0 : n3 >> 16;
            for (int i2 = sparseIntArray.size() - 1; i2 >= 0; --i2) {
                if (sparseIntArray.keyAt(i2) > n5) continue;
                return sparseIntArray.valueAt(i2);
            }
        }
        return n4;
    }
}

