/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.a;

public class Analyzer
implements Opcodes {
    private final Interpreter interpreter;
    private int n;
    private InsnList insns;
    private List[] handlers;
    private Frame[] frames;
    private a[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;

    public Analyzer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Frame[] analyze(String string, MethodNode methodNode) throws AnalyzerException {
        int n2;
        Type[] typeArray;
        Object object;
        if ((methodNode.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        this.n = methodNode.instructions.size();
        this.insns = methodNode.instructions;
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new a[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (int i2 = 0; i2 < methodNode.tryCatchBlocks.size(); ++i2) {
            object = (TryCatchBlockNode)methodNode.tryCatchBlocks.get(i2);
            int n3 = this.insns.indexOf(((TryCatchBlockNode)object).start);
            int n4 = this.insns.indexOf(((TryCatchBlockNode)object).end);
            for (int i3 = n3; i3 < n4; ++i3) {
                typeArray = this.handlers[i3];
                if (typeArray == null) {
                    this.handlers[i3] = typeArray = new ArrayList();
                }
                typeArray.add(object);
            }
        }
        a a2 = new a(null, methodNode.maxLocals, null);
        object = new ArrayList();
        HashMap<LabelNode, a> hashMap = new HashMap<LabelNode, a>();
        this.findSubroutine(0, a2, (List)object);
        while (!object.isEmpty()) {
            JumpInsnNode jumpInsnNode = (JumpInsnNode)object.remove(0);
            a a3 = (a)hashMap.get(jumpInsnNode.label);
            if (a3 == null) {
                a3 = new a(jumpInsnNode.label, methodNode.maxLocals, jumpInsnNode);
                hashMap.put(jumpInsnNode.label, a3);
                this.findSubroutine(this.insns.indexOf(jumpInsnNode.label), a3, (List)object);
                continue;
            }
            a3.a.add(jumpInsnNode);
        }
        for (int i4 = 0; i4 < this.n; ++i4) {
            if (this.subroutines[i4] == null || this.subroutines[i4].a != null) continue;
            this.subroutines[i4] = null;
        }
        Frame frame = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        Frame frame2 = this.newFrame(methodNode.maxLocals, methodNode.maxStack);
        frame.setReturn(this.interpreter.newValue(Type.getReturnType(methodNode.desc)));
        typeArray = Type.getArgumentTypes(methodNode.desc);
        int n5 = 0;
        if ((methodNode.access & 8) == 0) {
            Type type = Type.getObjectType(string);
            frame.setLocal(n5++, this.interpreter.newValue(type));
        }
        for (n2 = 0; n2 < typeArray.length; ++n2) {
            frame.setLocal(n5++, this.interpreter.newValue(typeArray[n2]));
            if (typeArray[n2].getSize() != 2) continue;
            frame.setLocal(n5++, this.interpreter.newValue(null));
        }
        while (n5 < methodNode.maxLocals) {
            frame.setLocal(n5++, this.interpreter.newValue(null));
        }
        this.merge(0, frame, null);
        this.init(string, methodNode);
        while (this.top > 0) {
            n2 = this.queue[--this.top];
            Frame frame3 = this.frames[n2];
            a a4 = this.subroutines[n2];
            this.queued[n2] = false;
            AbstractInsnNode abstractInsnNode = null;
            try {
                Object object2;
                int n6;
                Object object3;
                abstractInsnNode = methodNode.instructions.get(n2);
                int n7 = abstractInsnNode.getOpcode();
                int n8 = abstractInsnNode.getType();
                if (n8 == 8 || n8 == 15 || n8 == 14) {
                    this.merge(n2 + 1, frame3, a4);
                    this.newControlFlowEdge(n2, n2 + 1);
                } else {
                    int n9;
                    frame.init(frame3).execute(abstractInsnNode, this.interpreter);
                    a a5 = a4 = a4 == null ? null : a4.a();
                    if (abstractInsnNode instanceof JumpInsnNode) {
                        object3 = (JumpInsnNode)abstractInsnNode;
                        if (n7 != 167 && n7 != 168) {
                            this.merge(n2 + 1, frame, a4);
                            this.newControlFlowEdge(n2, n2 + 1);
                        }
                        n6 = this.insns.indexOf(((JumpInsnNode)object3).label);
                        if (n7 == 168) {
                            this.merge(n6, frame, new a(((JumpInsnNode)object3).label, methodNode.maxLocals, (JumpInsnNode)object3));
                        } else {
                            this.merge(n6, frame, a4);
                        }
                        this.newControlFlowEdge(n2, n6);
                    } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                        object3 = (LookupSwitchInsnNode)abstractInsnNode;
                        n6 = this.insns.indexOf(((LookupSwitchInsnNode)object3).dflt);
                        this.merge(n6, frame, a4);
                        this.newControlFlowEdge(n2, n6);
                        for (n9 = 0; n9 < ((LookupSwitchInsnNode)object3).labels.size(); ++n9) {
                            object2 = (LabelNode)((LookupSwitchInsnNode)object3).labels.get(n9);
                            n6 = this.insns.indexOf((AbstractInsnNode)object2);
                            this.merge(n6, frame, a4);
                            this.newControlFlowEdge(n2, n6);
                        }
                    } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                        object3 = (TableSwitchInsnNode)abstractInsnNode;
                        n6 = this.insns.indexOf(((TableSwitchInsnNode)object3).dflt);
                        this.merge(n6, frame, a4);
                        this.newControlFlowEdge(n2, n6);
                        for (n9 = 0; n9 < ((TableSwitchInsnNode)object3).labels.size(); ++n9) {
                            object2 = (LabelNode)((TableSwitchInsnNode)object3).labels.get(n9);
                            n6 = this.insns.indexOf((AbstractInsnNode)object2);
                            this.merge(n6, frame, a4);
                            this.newControlFlowEdge(n2, n6);
                        }
                    } else if (n7 == 169) {
                        if (a4 == null) {
                            throw new AnalyzerException(abstractInsnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i5 = 0; i5 < a4.a.size(); ++i5) {
                            JumpInsnNode jumpInsnNode = (JumpInsnNode)a4.a.get(i5);
                            n9 = this.insns.indexOf(jumpInsnNode);
                            if (this.frames[n9] == null) continue;
                            this.merge(n9 + 1, this.frames[n9], frame, this.subroutines[n9], a4.a);
                            this.newControlFlowEdge(n2, n9 + 1);
                        }
                    } else if (n7 != 191 && (n7 < 172 || n7 > 177)) {
                        if (a4 != null) {
                            if (abstractInsnNode instanceof VarInsnNode) {
                                int n10 = ((VarInsnNode)abstractInsnNode).var;
                                a4.a[n10] = true;
                                if (n7 == 22 || n7 == 24 || n7 == 55 || n7 == 57) {
                                    a4.a[n10 + 1] = true;
                                }
                            } else if (abstractInsnNode instanceof IincInsnNode) {
                                int n11 = ((IincInsnNode)abstractInsnNode).var;
                                a4.a[n11] = true;
                            }
                        }
                        this.merge(n2 + 1, frame, a4);
                        this.newControlFlowEdge(n2, n2 + 1);
                    }
                }
                if ((object3 = this.handlers[n2]) == null) continue;
                for (n6 = 0; n6 < object3.size(); ++n6) {
                    TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)object3.get(n6);
                    object2 = tryCatchBlockNode.type == null ? Type.getObjectType("java/lang/Throwable") : Type.getObjectType(tryCatchBlockNode.type);
                    int n12 = this.insns.indexOf(tryCatchBlockNode.handler);
                    if (!this.newControlFlowExceptionEdge(n2, tryCatchBlockNode)) continue;
                    frame2.init(frame3);
                    frame2.clearStack();
                    frame2.push(this.interpreter.newValue((Type)object2));
                    this.merge(n12, frame2, a4);
                }
            }
            catch (AnalyzerException analyzerException) {
                throw new AnalyzerException(analyzerException.node, new StringBuffer().append("Error at instruction ").append(n2).append(": ").append(analyzerException.getMessage()).toString(), analyzerException);
            }
            catch (Exception exception) {
                throw new AnalyzerException(abstractInsnNode, new StringBuffer().append("Error at instruction ").append(n2).append(": ").append(exception.getMessage()).toString(), exception);
            }
        }
        return this.frames;
    }

    private void findSubroutine(int n2, a a2, List list2) throws AnalyzerException {
        while (true) {
            Object object;
            int n3;
            Object object2;
            if (n2 < 0 || n2 >= this.n) {
                throw new AnalyzerException(null, "Execution can fall off end of the code");
            }
            if (this.subroutines[n2] != null) {
                return;
            }
            this.subroutines[n2] = a2.a();
            AbstractInsnNode abstractInsnNode = this.insns.get(n2);
            if (abstractInsnNode instanceof JumpInsnNode) {
                if (abstractInsnNode.getOpcode() == 168) {
                    list2.add(abstractInsnNode);
                } else {
                    object2 = (JumpInsnNode)abstractInsnNode;
                    this.findSubroutine(this.insns.indexOf(((JumpInsnNode)object2).label), a2, list2);
                }
            } else if (abstractInsnNode instanceof TableSwitchInsnNode) {
                object2 = (TableSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insns.indexOf(((TableSwitchInsnNode)object2).dflt), a2, list2);
                for (n3 = ((TableSwitchInsnNode)object2).labels.size() - 1; n3 >= 0; --n3) {
                    object = (LabelNode)((TableSwitchInsnNode)object2).labels.get(n3);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)object), a2, list2);
                }
            } else if (abstractInsnNode instanceof LookupSwitchInsnNode) {
                object2 = (LookupSwitchInsnNode)abstractInsnNode;
                this.findSubroutine(this.insns.indexOf(((LookupSwitchInsnNode)object2).dflt), a2, list2);
                for (n3 = ((LookupSwitchInsnNode)object2).labels.size() - 1; n3 >= 0; --n3) {
                    object = (LabelNode)((LookupSwitchInsnNode)object2).labels.get(n3);
                    this.findSubroutine(this.insns.indexOf((AbstractInsnNode)object), a2, list2);
                }
            }
            object2 = this.handlers[n2];
            if (object2 != null) {
                for (n3 = 0; n3 < object2.size(); ++n3) {
                    object = (TryCatchBlockNode)object2.get(n3);
                    this.findSubroutine(this.insns.indexOf(((TryCatchBlockNode)object).handler), a2, list2);
                }
            }
            switch (abstractInsnNode.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    return;
                }
            }
            ++n2;
        }
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    protected void init(String string, MethodNode methodNode) throws AnalyzerException {
    }

    protected Frame newFrame(int n2, int n3) {
        return new Frame(n2, n3);
    }

    protected Frame newFrame(Frame frame) {
        return new Frame(frame);
    }

    protected void newControlFlowEdge(int n2, int n3) {
    }

    protected boolean newControlFlowExceptionEdge(int n2, int n3) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int n2, TryCatchBlockNode tryCatchBlockNode) {
        return this.newControlFlowExceptionEdge(n2, this.insns.indexOf(tryCatchBlockNode.handler));
    }

    private void merge(int n2, Frame frame, a a2) throws AnalyzerException {
        boolean bl2;
        Frame frame2 = this.frames[n2];
        a a3 = this.subroutines[n2];
        if (frame2 == null) {
            this.frames[n2] = this.newFrame(frame);
            bl2 = true;
        } else {
            bl2 = frame2.merge(frame, this.interpreter);
        }
        if (a3 == null) {
            if (a2 != null) {
                this.subroutines[n2] = a2.a();
                bl2 = true;
            }
        } else if (a2 != null) {
            bl2 |= a3.a(a2);
        }
        if (bl2 && !this.queued[n2]) {
            this.queued[n2] = true;
            this.queue[this.top++] = n2;
        }
    }

    private void merge(int n2, Frame frame, Frame frame2, a a2, boolean[] blArray) throws AnalyzerException {
        boolean bl2;
        Frame frame3 = this.frames[n2];
        a a3 = this.subroutines[n2];
        frame2.merge(frame, blArray);
        if (frame3 == null) {
            this.frames[n2] = this.newFrame(frame2);
            bl2 = true;
        } else {
            bl2 = frame3.merge(frame2, this.interpreter);
        }
        if (a3 != null && a2 != null) {
            bl2 |= a3.a(a2);
        }
        if (bl2 && !this.queued[n2]) {
            this.queued[n2] = true;
            this.queue[this.top++] = n2;
        }
    }
}

