/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XPropertyEvent$Buffer;

public class XPropertyEvent
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int ATOM;
    public static final int TIME;
    public static final int STATE;

    protected XPropertyEvent(long l2, ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XPropertyEvent create(long l2, ByteBuffer byteBuffer) {
        return new XPropertyEvent(l2, byteBuffer);
    }

    public XPropertyEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XPropertyEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XPropertyEvent.ntype(this.address());
    }

    public long serial() {
        return XPropertyEvent.nserial(this.address());
    }

    public boolean send_event() {
        return XPropertyEvent.nsend_event(this.address()) != 0;
    }

    public long display() {
        return XPropertyEvent.ndisplay(this.address());
    }

    public long window() {
        return XPropertyEvent.nwindow(this.address());
    }

    public long atom() {
        return XPropertyEvent.natom(this.address());
    }

    public long time() {
        return XPropertyEvent.ntime(this.address());
    }

    public int state() {
        return XPropertyEvent.nstate(this.address());
    }

    public XPropertyEvent type(int n2) {
        XPropertyEvent.ntype(this.address(), n2);
        return this;
    }

    public XPropertyEvent serial(long l2) {
        XPropertyEvent.nserial(this.address(), l2);
        return this;
    }

    public XPropertyEvent send_event(boolean bl2) {
        XPropertyEvent.nsend_event(this.address(), bl2 ? 1 : 0);
        return this;
    }

    public XPropertyEvent display(long l2) {
        XPropertyEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XPropertyEvent window(long l2) {
        XPropertyEvent.nwindow(this.address(), l2);
        return this;
    }

    public XPropertyEvent atom(long l2) {
        XPropertyEvent.natom(this.address(), l2);
        return this;
    }

    public XPropertyEvent time(long l2) {
        XPropertyEvent.ntime(this.address(), l2);
        return this;
    }

    public XPropertyEvent state(int n2) {
        XPropertyEvent.nstate(this.address(), n2);
        return this;
    }

    public XPropertyEvent set(int n2, long l2, boolean bl2, long l3, long l4, long l5, long l6, int n3) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl2);
        this.display(l3);
        this.window(l4);
        this.atom(l5);
        this.time(l6);
        this.state(n3);
        return this;
    }

    public XPropertyEvent set(XPropertyEvent xPropertyEvent) {
        MemoryUtil.memCopy(xPropertyEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XPropertyEvent malloc() {
        return new XPropertyEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XPropertyEvent calloc() {
        return new XPropertyEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XPropertyEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XPropertyEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XPropertyEvent create(long l2) {
        return new XPropertyEvent(l2, null);
    }

    public static XPropertyEvent createSafe(long l2) {
        return l2 == 0L ? null : new XPropertyEvent(l2, null);
    }

    public static XPropertyEvent$Buffer malloc(int n2) {
        return new XPropertyEvent$Buffer(MemoryUtil.nmemAllocChecked(XPropertyEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XPropertyEvent$Buffer calloc(int n2) {
        return new XPropertyEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XPropertyEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XPropertyEvent.__create(n2, SIZEOF);
        return new XPropertyEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n2, n2);
    }

    public static XPropertyEvent$Buffer create(long l2, int n2) {
        return new XPropertyEvent$Buffer(l2, n2);
    }

    public static XPropertyEvent$Buffer createSafe(long l2, int n2) {
        return l2 == 0L ? null : new XPropertyEvent$Buffer(l2, n2);
    }

    public static XPropertyEvent mallocStack() {
        return XPropertyEvent.malloc(MemoryStack.stackGet());
    }

    public static XPropertyEvent callocStack() {
        return XPropertyEvent.calloc(MemoryStack.stackGet());
    }

    public static XPropertyEvent mallocStack(MemoryStack memoryStack) {
        return XPropertyEvent.malloc(memoryStack);
    }

    public static XPropertyEvent callocStack(MemoryStack memoryStack) {
        return XPropertyEvent.calloc(memoryStack);
    }

    public static XPropertyEvent$Buffer mallocStack(int n2) {
        return XPropertyEvent.malloc(n2, MemoryStack.stackGet());
    }

    public static XPropertyEvent$Buffer callocStack(int n2) {
        return XPropertyEvent.calloc(n2, MemoryStack.stackGet());
    }

    public static XPropertyEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XPropertyEvent.malloc(n2, memoryStack);
    }

    public static XPropertyEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XPropertyEvent.calloc(n2, memoryStack);
    }

    public static XPropertyEvent malloc(MemoryStack memoryStack) {
        return new XPropertyEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XPropertyEvent calloc(MemoryStack memoryStack) {
        return new XPropertyEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XPropertyEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XPropertyEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XPropertyEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XPropertyEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static long natom(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)ATOM);
    }

    public static long ntime(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)TIME);
    }

    public static int nstate(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)STATE);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void natom(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)ATOM, l3);
    }

    public static void ntime(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)TIME, l3);
    }

    public static void nstate(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)STATE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XPropertyEvent.__struct(XPropertyEvent.__member(4), XPropertyEvent.__member(CLONG_SIZE), XPropertyEvent.__member(4), XPropertyEvent.__member(POINTER_SIZE), XPropertyEvent.__member(CLONG_SIZE), XPropertyEvent.__member(CLONG_SIZE), XPropertyEvent.__member(CLONG_SIZE), XPropertyEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        ATOM = struct$Layout.offsetof(5);
        TIME = struct$Layout.offsetof(6);
        STATE = struct$Layout.offsetof(7);
    }
}

