/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BUTTON_IMAGELIST;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    String message = "";
    Image image;
    Image image2;
    Image disabledImage;
    ImageList imageList;
    boolean ignoreMouse;
    boolean grayed;
    int buttonBackground = -1;
    int buttonBackgroundAlpha = 255;
    static final int MARGIN = 4;
    static final int CHECK_WIDTH;
    static final int CHECK_HEIGHT;
    static final int ICON_WIDTH = 128;
    static final int ICON_HEIGHT = 128;
    static boolean COMMAND_LINK;
    static final int ButtonProc;
    static final TCHAR ButtonClass;

    public Button(Composite composite, int n2) {
        super(composite, Button.checkStyle(n2));
    }

    void _setImage(Image image) {
        if ((this.style & 0x400000) != 0) {
            return;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = null;
            if (image != null) {
                int n2;
                this.imageList = new ImageList(this.style & 0x4000000);
                if (OS.IsWindowEnabled(this.handle)) {
                    this.imageList.add(image);
                } else {
                    if (this.disabledImage != null) {
                        this.disabledImage.dispose();
                    }
                    this.disabledImage = new Image((Device)this.display, image, 1);
                    this.imageList.add(this.disabledImage);
                }
                BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
                bUTTON_IMAGELIST.himl = this.imageList.getHandle();
                int n3 = n2 = OS.GetWindowLong(this.handle, -16);
                n3 &= 0xFFFFFCFF;
                if ((this.style & 0x4000) != 0) {
                    n3 |= 0x100;
                }
                if ((this.style & 0x1000000) != 0) {
                    n3 |= 0x300;
                }
                if ((this.style & 0x20000) != 0) {
                    n3 |= 0x200;
                }
                if (this.text.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        bUTTON_IMAGELIST.uAlign = 1;
                    }
                } else {
                    bUTTON_IMAGELIST.uAlign = 0;
                    bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                    bUTTON_IMAGELIST.margin_right = 4;
                    n3 &= 0xFFFFFCFF;
                    n3 |= 0x100;
                }
                if (n3 != n2) {
                    OS.SetWindowLong(this.handle, -16, n3);
                    OS.InvalidateRect(this.handle, null, true);
                }
                OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
            } else {
                OS.SendMessage(this.handle, 5634, 0, 0);
            }
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n4;
            if (this.image2 != null) {
                this.image2.dispose();
            }
            this.image2 = null;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (image != null) {
                Rectangle rectangle;
                switch (image.type) {
                    case 0: {
                        rectangle = image.getBounds();
                        ImageData imageData = image.getImageData();
                        switch (imageData.getTransparencyType()) {
                            case 4: {
                                if (rectangle.width <= 128 && rectangle.height <= 128) {
                                    this.image2 = new Image((Device)this.display, imageData, imageData.getTransparencyMask());
                                    n5 = this.image2.handle;
                                    n6 = 64;
                                    n7 = 1;
                                    break;
                                }
                            }
                            case 1: {
                                this.image2 = new Image((Device)this.display, rectangle.width, rectangle.height);
                                GC gC = new GC(this.image2);
                                gC.setBackground(this.getBackground());
                                gC.fillRectangle(rectangle);
                                gC.drawImage(image, 0, 0);
                                gC.dispose();
                                n5 = this.image2.handle;
                                n6 = 128;
                                n7 = 0;
                                break;
                            }
                            case 0: {
                                n5 = image.handle;
                                n6 = 128;
                                n7 = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        n5 = image.handle;
                        n6 = 64;
                        n7 = 1;
                    }
                }
                if ((this.style & 0x4000000) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                    rectangle = image.getBoundsInPixels();
                    int n8 = OS.GetDC(this.handle);
                    int n9 = OS.CreateCompatibleDC(n8);
                    int n10 = OS.CreateCompatibleBitmap(n8, rectangle.width, rectangle.height);
                    int n11 = OS.SelectObject(n9, n10);
                    OS.SetLayout(n9, 1);
                    if (n7 == 0) {
                        int n12 = OS.CreateCompatibleDC(n8);
                        int n13 = OS.SelectObject(n12, n5);
                        OS.SetLayout(n9, 0);
                        OS.BitBlt(n9, 0, 0, rectangle.width, rectangle.height, n12, 0, 0, 0xCC0020);
                        OS.SelectObject(n12, n13);
                        OS.DeleteDC(n12);
                    } else {
                        Control control = this.findBackgroundControl();
                        if (control == null) {
                            control = this;
                        }
                        int n14 = OS.CreateSolidBrush(control.getBackgroundPixel());
                        int n15 = OS.SelectObject(n9, n14);
                        OS.PatBlt(n9, 0, 0, rectangle.width, rectangle.height, 15728673);
                        OS.DrawIconEx(n9, 0, 0, n5, 0, 0, 0, 0, 3);
                        OS.SelectObject(n9, n15);
                        OS.DeleteObject(n14);
                    }
                    OS.SelectObject(n9, n11);
                    OS.DeleteDC(n9);
                    OS.ReleaseDC(this.handle, n8);
                    if (this.image2 != null) {
                        this.image2.dispose();
                    }
                    this.image2 = Image.win32_new(this.display, 0, n10);
                    n6 = 128;
                    n7 = 0;
                    n5 = n10;
                }
            }
            int n16 = n4 = OS.GetWindowLong(this.handle, -16);
            n4 &= 0xFFFFFF3F;
            if ((n4 |= n6) != n16) {
                OS.SetWindowLong(this.handle, -16, n4);
            }
            OS.SendMessage(this.handle, 247, n7, n5);
        }
    }

    void _setText(String string) {
        Object object;
        int n2;
        int n3 = n2 = OS.GetWindowLong(this.handle, -16);
        if (OS.COMCTL32_MAJOR >= 6) {
            n3 &= 0xFFFFFCFF;
            if ((this.style & 0x4000) != 0) {
                n3 |= 0x100;
            }
            if ((this.style & 0x1000000) != 0) {
                n3 |= 0x300;
            }
            if ((this.style & 0x20000) != 0) {
                n3 |= 0x200;
            }
            if (this.imageList != null) {
                object = new BUTTON_IMAGELIST();
                ((BUTTON_IMAGELIST)object).himl = this.imageList.getHandle();
                if (string.length() == 0) {
                    if ((this.style & 0x4000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 0;
                    }
                    if ((this.style & 0x1000000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 4;
                    }
                    if ((this.style & 0x20000) != 0) {
                        ((BUTTON_IMAGELIST)object).uAlign = 1;
                    }
                } else {
                    ((BUTTON_IMAGELIST)object).uAlign = 0;
                    ((BUTTON_IMAGELIST)object).margin_left = this.computeLeftMargin();
                    ((BUTTON_IMAGELIST)object).margin_right = 4;
                    n3 &= 0xFFFFFCFF;
                    n3 |= 0x100;
                }
                OS.SendMessage(this.handle, 5634, 0, (BUTTON_IMAGELIST)object);
            }
        } else {
            n3 &= 0xFFFFFF3F;
        }
        if (n3 != n2) {
            OS.SetWindowLong(this.handle, -16, n3);
            OS.InvalidateRect(this.handle, null, true);
        }
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            string = OS.IsWindowEnabled(this.handle) ? string : string + " ";
        }
        object = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, (TCHAR)object);
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ButtonProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        if (((n2 = Button.checkBits(n2, 8, 4, 32, 16, 2, COMMAND_LINK ? 0x400000 : 0)) & 0xA) != 0) {
            return Button.checkBits(n2, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n2 & 0x30) != 0) {
            return Button.checkBits(n2, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n2 & 4) != 0) {
            return Button.checkBits(n2 |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n2;
    }

    void click() {
        this.ignoreMouse = true;
        OS.SendMessage(this.handle, 245, 0, 0);
        this.ignoreMouse = false;
    }

    int computeLeftMargin() {
        if (OS.COMCTL32_MAJOR < 6) {
            return 4;
        }
        if ((this.style & 0xA) == 0) {
            return 4;
        }
        int n2 = 0;
        if (this.image != null && this.text.length() != 0) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            n2 += rectangle.width + 8;
            int n3 = 0;
            int n4 = OS.GetDC(this.handle);
            int n5 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n5 != 0) {
                n3 = OS.SelectObject(n4, n5);
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
            RECT rECT = new RECT();
            int n6 = 1056;
            OS.DrawText(n4, tCHAR, -1, rECT, n6);
            n2 += rECT.right - rECT.left;
            if (n5 != 0) {
                OS.SelectObject(n4, n3);
            }
            OS.ReleaseDC(this.handle, n4);
            OS.GetClientRect(this.handle, rECT);
            n2 = Math.max(4, (rECT.right - rECT.left - n2) / 2);
        }
        return n2;
    }

    @Override
    Point computeSizeInPixels(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getBorderWidthInPixels();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                n4 += OS.GetSystemMetrics(2);
                n5 += OS.GetSystemMetrics(20);
            } else {
                n4 += OS.GetSystemMetrics(21);
                n5 += OS.GetSystemMetrics(3);
            }
        } else if ((this.style & 0x400000) != 0) {
            SIZE sIZE = new SIZE();
            if (n2 != -1) {
                sIZE.cx = n2;
                OS.SendMessage(this.handle, 5633, 0, sIZE);
                n4 = sIZE.cx;
                n5 = sIZE.cy;
            } else {
                OS.SendMessage(this.handle, 5633, 0, sIZE);
                n4 = sIZE.cy;
                n5 = sIZE.cy;
                sIZE.cy = 0;
                while (sIZE.cy != n5) {
                    sIZE.cx = n4++;
                    sIZE.cy = 0;
                    OS.SendMessage(this.handle, 5633, 0, sIZE);
                }
            }
        } else {
            int n7;
            int n8 = 0;
            boolean bl3 = this.image != null;
            boolean bl4 = true;
            if (OS.COMCTL32_MAJOR < 6 && (this.style & 8) == 0) {
                n7 = OS.GetWindowLong(this.handle, -16);
                boolean bl5 = bl3 = (n7 & 0xC0) != 0;
                if (bl3) {
                    bl4 = false;
                }
            }
            if (bl3 && this.image != null) {
                Rectangle rectangle = this.image.getBoundsInPixels();
                n4 = rectangle.width;
                if (bl4 && this.text.length() != 0) {
                    n4 += 8;
                }
                n5 = rectangle.height;
                n8 = 8;
            }
            if (bl4) {
                n7 = 0;
                int n9 = OS.GetDC(this.handle);
                int n10 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n10 != 0) {
                    n7 = OS.SelectObject(n9, n10);
                }
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n9, tEXTMETRIC);
                int n11 = this.text.length();
                if (n11 == 0) {
                    n5 = Math.max(n5, tEXTMETRIC.tmHeight);
                } else {
                    n8 = Math.max(8, tEXTMETRIC.tmAveCharWidth);
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), this.text, true);
                    RECT rECT = new RECT();
                    int n12 = 1056;
                    if ((this.style & 0x40) != 0 && n2 != -1) {
                        n12 = 1040;
                        rECT.right = n2 - n4 - 2 * n6;
                        rECT.right = this.isRadioOrCheck() ? (rECT.right -= CHECK_WIDTH + 3) : (rECT.right -= 6);
                        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
                            rECT.right -= 2;
                            if (this.isRadioOrCheck()) {
                                rECT.right -= 2;
                            }
                        }
                    }
                    OS.DrawText(n9, tCHAR, -1, rECT, n12);
                    n4 += rECT.right - rECT.left;
                    n5 = Math.max(n5, rECT.bottom - rECT.top);
                }
                if (n10 != 0) {
                    OS.SelectObject(n9, n7);
                }
                OS.ReleaseDC(this.handle, n9);
            }
            if (this.isRadioOrCheck()) {
                n4 += CHECK_WIDTH + n8;
                n5 = Math.max(n5, CHECK_HEIGHT + 3);
            }
            if ((this.style & 0xA) != 0) {
                n4 += 12;
                n5 += 10;
            }
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        return new Point(n4 += n6 * 2, n5 += n6 * 2);
    }

    @Override
    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                this.state |= 0x100;
            } else if ((this.style & 0xA) == 0) {
                this.state |= 0x100;
            }
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x10) != 0) {
            this.state |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && (this.style & 0xA) != 0) {
            this.state |= 0x200;
        }
    }

    private boolean customBackgroundDrawing() {
        return this.buttonBackground != -1 && !this.isRadioOrCheck();
    }

    private boolean customDrawing() {
        return this.customBackgroundDrawing() || this.customForegroundDrawing();
    }

    private boolean customForegroundDrawing() {
        return this.foreground != -1 && !this.text.isEmpty() && OS.IsWindowEnabled(this.handle);
    }

    @Override
    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    @Override
    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNTEXT);
    }

    @Override
    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            boolean bl3;
            int n2 = OS.GetWindowLong(this.handle, -16);
            boolean bl4 = bl3 = (n2 & 0xC0) != 0;
            if (!bl3) {
                String string = bl2 ? this.text : this.text + " ";
                TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
                OS.SetWindowText(this.handle, tCHAR);
            }
        }
        this.updateImageList();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    public Color getBackground() {
        if (this.isRadioOrCheck()) {
            return super.getBackground();
        }
        this.checkWidget();
        if (this.buttonBackground != -1) {
            return Color.win32_new(this.display, this.buttonBackground, this.buttonBackgroundAlpha);
        }
        return Color.win32_new(this.display, this.defaultBackground());
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int n2 = OS.GetWindowLong(this.handle, -16);
        return (n2 & 1) != 0;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return this.isChecked();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    private boolean isChecked() {
        int n2 = OS.SendMessage(this.handle, 240, 0, 0);
        return n2 != 0;
    }

    private boolean isRadioOrCheck() {
        return (this.style & 0x30) != 0;
    }

    @Override
    boolean isTabItem() {
        if ((this.style & 8) != 0) {
            return this.isTabGroup();
        }
        return super.isTabItem();
    }

    @Override
    boolean mnemonicHit(char c2) {
        if (!this.setFocus()) {
            return false;
        }
        if ((this.style & 0x10) == 0) {
            this.click();
        }
        return true;
    }

    @Override
    boolean mnemonicMatch(char c2) {
        char c3 = this.findMnemonic(this.getText());
        if (c3 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        this.disabledImage = null;
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.text = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    int resolveTextDirection() {
        return (this.style & 4) != 0 ? 0 : BidiUtil.resolveTextDirection(this.text);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (this == control) continue;
            control.setRadioSelection(false);
        }
        this.setSelection(true);
    }

    public void setAlignment(int n2) {
        int n3;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n2 & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((n2 & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n2 & 0x1024000;
        int n4 = n3 = OS.GetWindowLong(this.handle, -16);
        n4 &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            n4 |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n4 |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n4 |= 0x200;
        }
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            if (this.text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    bUTTON_IMAGELIST.uAlign = 1;
                }
            } else {
                bUTTON_IMAGELIST.uAlign = 0;
                bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
                bUTTON_IMAGELIST.margin_right = 4;
                n4 &= 0xFFFFFCFF;
                n4 |= 0x100;
            }
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
        }
        if (n4 != n3) {
            OS.SetWindowLong(this.handle, -16, n4);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    public void setBackground(Color color) {
        this.checkWidget();
        if (this.isRadioOrCheck()) {
            super.setBackground(color);
        } else {
            this.setButtonBackground(color);
        }
    }

    private void setButtonBackground(Color color) {
        int n2 = -1;
        int n3 = 255;
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            n2 = color.handle;
            n3 = color.getAlpha();
        }
        if (n2 == this.buttonBackground && n3 == this.buttonBackgroundAlpha) {
            return;
        }
        this.buttonBackground = n2;
        this.buttonBackgroundAlpha = n3;
        this.updateBackgroundColor();
    }

    void setDefault(boolean bl2) {
        if ((this.style & 8) == 0) {
            return;
        }
        int n2 = this.menuShell().handle;
        int n3 = OS.GetWindowLong(this.handle, -16);
        if (bl2) {
            n3 |= 1;
            OS.SendMessage(n2, 1025, this.handle, 0);
        } else {
            n3 &= 0xFFFFFFFE;
            OS.SendMessage(n2, 1025, 0, 0);
        }
        OS.SendMessage(this.handle, 244, n3, 1);
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x10) != 0 && !this.isChecked() && this.display.fixFocus) {
            return false;
        }
        return super.setFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl2;
        int n2 = OS.SendMessage(this.handle, 240, 0, 0);
        if (bl2) {
            if (n2 == 1) {
                this.updateSelection(2);
            }
        } else if (n2 == 2) {
            this.updateSelection(1);
        }
    }

    void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (OS.COMCTL32_VERSION >= OS.VERSION(6, 1) && (this.style & 0x400000) != 0) {
            int n2 = string.length();
            char[] cArray = new char[n2 + 1];
            string.getChars(0, n2, cArray, 0);
            OS.SendMessage(this.handle, 5641, 0, cArray);
        }
    }

    @Override
    boolean setRadioFocus(boolean bl2) {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return bl2 ? this.setTabItemFocus() : this.setFocus();
    }

    @Override
    boolean setRadioSelection(boolean bl2) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl2) {
            this.setSelection(bl2);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    @Override
    boolean setSavedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setSavedFocus();
    }

    public void setSelection(boolean bl2) {
        int n2;
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int n3 = n2 = bl2 ? 1 : 0;
        if ((this.style & 0x20) != 0 && bl2 && this.grayed) {
            n2 = 2;
        }
        this.updateSelection(n2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        this._setText(string);
    }

    @Override
    boolean updateTextDirection(int n2) {
        return super.updateTextDirection(n2);
    }

    void updateImageList() {
        if (OS.COMCTL32_MAJOR >= 6 && this.imageList != null) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0, bUTTON_IMAGELIST);
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = new ImageList(this.style & 0x4000000);
            if (OS.IsWindowEnabled(this.handle)) {
                this.imageList.add(this.image);
            } else {
                if (this.disabledImage != null) {
                    this.disabledImage.dispose();
                }
                this.disabledImage = new Image((Device)this.display, this.image, 1);
                this.imageList.add(this.disabledImage);
            }
            bUTTON_IMAGELIST.himl = this.imageList.getHandle();
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        this.updateImageList();
    }

    void updateSelection(int n2) {
        if (n2 != OS.SendMessage(this.handle, 240, 0, 0)) {
            int n3 = OS.GetWindowLong(this.handle, -16);
            if ((this.style & 0x20) != 0) {
                if (n2 == 2) {
                    n3 &= 0xFFFFFFFD;
                    n3 |= 5;
                } else {
                    n3 |= 2;
                    n3 &= 0xFFFFFFFA;
                }
                if (n3 != OS.GetWindowLong(this.handle, -16)) {
                    OS.SetWindowLong(this.handle, -16, n3);
                }
            }
            OS.SendMessage(this.handle, 241, n2, 0);
            if (n3 != OS.GetWindowLong(this.handle, -16)) {
                OS.SetWindowLong(this.handle, -16, n3);
            }
        }
    }

    @Override
    int widgetStyle() {
        int n2 = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            n2 |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return n2 | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            n2 |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            n2 |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            n2 |= 0x200;
        }
        if ((this.style & 0x40) != 0) {
            n2 |= 0x2000;
        }
        if ((this.style & 8) != 0) {
            return n2 | 0 | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return n2 | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return n2 | 4;
        }
        if ((this.style & 2) != 0) {
            return n2 | 0x1000 | 2 | 0x10000;
        }
        if ((this.style & 0x400000) != 0) {
            return n2 | 0xE | 0x10000;
        }
        return n2 | 0 | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return ButtonClass;
    }

    @Override
    int windowProc() {
        return ButtonProc;
    }

    @Override
    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6 && this.isRadioOrCheck() && this.findImageControl() != null) {
            this.drawBackground(n2);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_GETOBJECT(int n2, int n3) {
        if ((this.style & 0x10) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n2, n3);
    }

    @Override
    LRESULT WM_KILLFOCUS(int n2, int n3) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n2, n3);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(int n2, int n3) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(n2, n3);
    }

    @Override
    LRESULT WM_LBUTTONUP(int n2, int n3) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(n2, n3);
    }

    @Override
    LRESULT WM_SETFOCUS(int n2, int n3) {
        int n4 = 0;
        if ((this.style & 0x10) != 0) {
            n4 = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT lRESULT = super.WM_SETFOCUS(n2, n3);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, n4);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && (this.style & 0xA) != 0 && this.imageList != null && this.text.length() != 0) {
            BUTTON_IMAGELIST bUTTON_IMAGELIST = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0, bUTTON_IMAGELIST);
            bUTTON_IMAGELIST.uAlign = 0;
            bUTTON_IMAGELIST.margin_left = this.computeLeftMargin();
            bUTTON_IMAGELIST.margin_right = 4;
            OS.SendMessage(this.handle, 5634, 0, bUTTON_IMAGELIST);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.image2 != null) {
            this._setImage(this.image);
        }
        return lRESULT;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x32) != 0) {
            boolean bl2;
            boolean bl3 = bl2 = this.findImageControl() != null;
            if (!bl2) {
                if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                    boolean bl4 = bl2 = this.findThemeControl() != null;
                }
                if (!bl2) {
                    boolean bl5 = bl2 = this.findBackgroundControl() != null;
                }
            }
            if (bl2) {
                OS.InvalidateRect(this.handle, null, false);
                int n4 = OS.DefWindowProc(this.handle, 296, n2, n3);
                return new LRESULT(n4);
            }
        }
        if ((this.style & 0xA) != 0 && (this.hooks(9) || this.filters(9) || this.customDrawing())) {
            OS.InvalidateRect(this.handle, null, true);
        }
        return lRESULT;
    }

    @Override
    LRESULT wmCommandChild(int n2, int n3) {
        int n4 = OS.HIWORD(n2);
        switch (n4) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.sendSelectionEvent(13);
            }
        }
        return super.wmCommandChild(n2, n3);
    }

    @Override
    LRESULT wmColorChild(int n2, int n3) {
        LRESULT lRESULT = super.wmColorChild(n2, n3);
        if (OS.COMCTL32_MAJOR < 6 && this.isRadioOrCheck() && this.findImageControl() != null) {
            OS.SetBkMode(n2, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return lRESULT;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -12: {
                if (OS.COMCTL32_MAJOR < 6) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n3, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        int n4;
                        int n5;
                        if (this.customBackgroundDrawing()) {
                            n5 = this.buttonBackground;
                            if ((nMCUSTOMDRAW.uItemState & 1) != 0) {
                                n5 = this.getDifferentColor(this.buttonBackground);
                            } else if ((nMCUSTOMDRAW.uItemState & 0x40) != 0) {
                                n5 = this.getSlightlyDifferentColor(this.buttonBackground);
                            }
                            if ((this.style & 2) != 0 && this.isChecked()) {
                                n5 = this.getDifferentColor(this.buttonBackground);
                            }
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, nMCUSTOMDRAW.left + 2, nMCUSTOMDRAW.top + 2, nMCUSTOMDRAW.right - 2, nMCUSTOMDRAW.bottom - 2);
                            n4 = OS.CreateSolidBrush(n5);
                            OS.FillRect(nMCUSTOMDRAW.hdc, rECT, n4);
                            OS.DeleteObject(n4);
                        }
                        if (this.customForegroundDrawing()) {
                            int n6;
                            Object object;
                            Object object2;
                            n5 = DPIUtil.autoScaleUpUsingNativeDPI(16);
                            int n7 = this.isRadioOrCheck() ? 0 : 3;
                            n4 = nMCUSTOMDRAW.left + n7;
                            int n8 = nMCUSTOMDRAW.right - n7;
                            if (this.image != null) {
                                object2 = new GCData();
                                ((GCData)object2).device = this.display;
                                object = GC.win32_new(nMCUSTOMDRAW.hdc, (GCData)object2);
                                n6 = this.computeLeftMargin();
                                int n9 = this.image.getBoundsInPixels().width;
                                n4 += n9 + (this.isRadioOrCheck() ? 8 : 4);
                                int n10 = n6 + (this.isRadioOrCheck() ? n5 : 3);
                                int n11 = Math.max(0, (nMCUSTOMDRAW.bottom - this.image.getBoundsInPixels().height) / 2);
                                ((GC)object).drawImage(this.image, DPIUtil.autoScaleDown(n10), DPIUtil.autoScaleDown(n11));
                                ((Resource)object).dispose();
                            }
                            int n12 = this.isRadioOrCheck() ? n5 : 0;
                            object2 = new RECT();
                            OS.SetRect((RECT)object2, n4 += n12, nMCUSTOMDRAW.top + n7, n8, nMCUSTOMDRAW.bottom - n7);
                            object = new TCHAR(this.getCodePage(), this.text, false);
                            n6 = 0;
                            if ((this.style & 0x40) != 0) {
                                n6 |= 0x10;
                                if (!this.isRadioOrCheck() && this.image != null) {
                                    ((RECT)object2).right -= 4;
                                }
                            } else {
                                n6 |= 0x20;
                            }
                            OS.DrawText(nMCUSTOMDRAW.hdc, (TCHAR)object, ((TCHAR)object).length(), (RECT)object2, n6 | 0x400);
                            OS.OffsetRect((RECT)object2, 0, Math.max(0, (nMCUSTOMDRAW.bottom - ((RECT)object2).bottom - n7) / 2));
                            if (this.image != null) {
                                n6 |= 0;
                                if (!this.isRadioOrCheck()) {
                                    OS.OffsetRect((RECT)object2, Math.max(4, (n8 - ((RECT)object2).right) / 2 + 1), 0);
                                }
                            } else if ((this.style & 0x4000) != 0) {
                                n6 |= 0;
                            } else if ((this.style & 0x20000) != 0) {
                                n6 |= 2;
                                OS.OffsetRect((RECT)object2, n8 - ((RECT)object2).right, 0);
                            } else {
                                n6 |= 1;
                                OS.OffsetRect((RECT)object2, (n8 - ((RECT)object2).right) / 2, 0);
                            }
                            OS.SetBkMode(nMCUSTOMDRAW.hdc, 1);
                            OS.SetTextColor(nMCUSTOMDRAW.hdc, this.foreground);
                            OS.DrawText(nMCUSTOMDRAW.hdc, (TCHAR)object, ((TCHAR)object).length(), (RECT)object2, n6);
                            if ((nMCUSTOMDRAW.uItemState & 0x10) != 0) {
                                RECT rECT = new RECT();
                                if (this.isRadioOrCheck()) {
                                    if (this.text.length() > 0) {
                                        OS.SetRect(rECT, ((RECT)object2).left - 1, ((RECT)object2).top, Math.min(nMCUSTOMDRAW.right, ((RECT)object2).right + 1), ((RECT)object2).bottom + 1);
                                    } else {
                                        OS.SetRect(rECT, nMCUSTOMDRAW.left + 1 + n5, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right - 2, nMCUSTOMDRAW.bottom - 1);
                                    }
                                } else {
                                    OS.SetRect(rECT, nMCUSTOMDRAW.left + 2, nMCUSTOMDRAW.top + 3, nMCUSTOMDRAW.right - 2, nMCUSTOMDRAW.bottom - 3);
                                }
                                OS.DrawFocusRect(nMCUSTOMDRAW.hdc, rECT);
                            }
                            return new LRESULT(4);
                        }
                        return new LRESULT(0);
                    }
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }

    @Override
    LRESULT wmDrawChild(int n2, int n3) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(n2, n3);
        }
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n3, DRAWITEMSTRUCT.sizeof);
        RECT rECT = new RECT();
        OS.SetRect(rECT, dRAWITEMSTRUCT.left, dRAWITEMSTRUCT.top, dRAWITEMSTRUCT.right, dRAWITEMSTRUCT.bottom);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n4 = 9;
            switch (this.style & 0x24480) {
                case 128: {
                    n4 = 1;
                    break;
                }
                case 1024: {
                    n4 = 5;
                    break;
                }
                case 16384: {
                    n4 = 9;
                    break;
                }
                case 131072: {
                    n4 = 13;
                }
            }
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && (this.style & 0x8000000) != 0 && (this.style & 0x24000) != 0) {
                int n5 = n4 = n4 == 13 ? 9 : 13;
            }
            if (!this.getEnabled()) {
                n4 += 3;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n4 += 2;
            }
            OS.DrawThemeBackground(this.display.hScrollBarTheme(), dRAWITEMSTRUCT.hDC, 1, n4, rECT, null);
        } else {
            int n6 = 2;
            switch (this.style & 0x24480) {
                case 128: {
                    n6 = 0;
                    break;
                }
                case 1024: {
                    n6 = 1;
                    break;
                }
                case 16384: {
                    n6 = 2;
                    break;
                }
                case 131072: {
                    n6 = 3;
                }
            }
            if (!this.getEnabled()) {
                n6 |= 0x100;
            }
            if ((this.style & 0x800000) == 0x800000) {
                n6 |= 0x4000;
            }
            if ((dRAWITEMSTRUCT.itemState & 1) != 0) {
                n6 |= 0x200;
            }
            OS.DrawFrameControl(dRAWITEMSTRUCT.hDC, rECT, 3, n6);
        }
        return null;
    }

    static {
        Object object;
        COMMAND_LINK = false;
        ButtonClass = new TCHAR(0, "BUTTON", true);
        int n2 = OS.LoadBitmap(0, 32759);
        if (n2 == 0) {
            CHECK_WIDTH = OS.GetSystemMetrics(OS.IsWinCE ? 49 : 2);
            CHECK_HEIGHT = OS.GetSystemMetrics(OS.IsWinCE ? 50 : 20);
        } else {
            object = new BITMAP();
            OS.GetObject(n2, BITMAP.sizeof, (BITMAP)object);
            OS.DeleteObject(n2);
            CHECK_WIDTH = ((BITMAP)object).bmWidth / 4;
            CHECK_HEIGHT = ((BITMAP)object).bmHeight / 3;
        }
        object = new WNDCLASS();
        OS.GetClassInfo(0, ButtonClass, (WNDCLASS)object);
        ButtonProc = ((WNDCLASS)object).lpfnWndProc;
    }
}

