/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class GridLayout
extends Layout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;

    public GridLayout() {
    }

    public GridLayout(int n2, boolean bl2) {
        this.numColumns = n2;
        this.makeColumnsEqualWidth = bl2;
    }

    @Override
    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Point point = this.layout(composite, false, 0, 0, n2, n3, bl2);
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        return point;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object object = control.getLayoutData();
        if (object != null) {
            ((GridData)object).flushCache();
        }
        return true;
    }

    GridData getData(Control[][] controlArray, int n2, int n3, int n4, int n5, boolean bl2) {
        Control control = controlArray[n2][n3];
        if (control != null) {
            int n6;
            GridData gridData = (GridData)control.getLayoutData();
            int n7 = Math.max(1, Math.min(gridData.horizontalSpan, n5));
            int n8 = Math.max(1, gridData.verticalSpan);
            int n9 = bl2 ? n2 + n8 - 1 : n2 - n8 + 1;
            int n10 = n6 = bl2 ? n3 + n7 - 1 : n3 - n7 + 1;
            if (0 <= n9 && n9 < n4 && 0 <= n6 && n6 < n5 && control == controlArray[n9][n6]) {
                return gridData;
            }
        }
        return null;
    }

    @Override
    protected void layout(Composite composite, boolean bl2) {
        Rectangle rectangle = composite.getClientArea();
        this.layout(composite, true, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
    }

    Point layout(Composite composite, boolean bl2, int n2, int n3, int n4, int n5, boolean bl3) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        Object object;
        int n24;
        Control[][] controlArray;
        int n25;
        GridData gridData;
        Control control;
        int n26;
        if (this.numColumns < 1) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        Control[] controlArray2 = composite.getChildren();
        int n27 = 0;
        for (n26 = 0; n26 < controlArray2.length; ++n26) {
            control = controlArray2[n26];
            gridData = (GridData)control.getLayoutData();
            if (gridData != null && gridData.exclude) continue;
            controlArray2[n27++] = controlArray2[n26];
        }
        if (n27 == 0) {
            return new Point(this.marginLeft + this.marginWidth * 2 + this.marginRight, this.marginTop + this.marginHeight * 2 + this.marginBottom);
        }
        for (n26 = 0; n26 < n27; ++n26) {
            control = controlArray2[n26];
            gridData = (GridData)control.getLayoutData();
            if (gridData == null) {
                gridData = new GridData();
                control.setLayoutData(gridData);
            }
            if (bl3) {
                gridData.flushCache();
            }
            gridData.computeSize(control, gridData.widthHint, gridData.heightHint, bl3);
            if (gridData.grabExcessHorizontalSpace && gridData.minimumWidth > 0 && gridData.cacheWidth < gridData.minimumWidth) {
                n25 = 0;
                if (control instanceof Scrollable) {
                    controlArray = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                    n25 = controlArray.width;
                } else {
                    n25 = control.getBorderWidth() * 2;
                }
                gridData.cacheHeight = -1;
                gridData.cacheWidth = -1;
                gridData.computeSize(control, Math.max(0, gridData.minimumWidth - n25), gridData.heightHint, false);
            }
            if (!gridData.grabExcessVerticalSpace || gridData.minimumHeight <= 0) continue;
            gridData.cacheHeight = Math.max(gridData.cacheHeight, gridData.minimumHeight);
        }
        n26 = 0;
        int n28 = 0;
        int n29 = 0;
        n25 = this.numColumns;
        controlArray = new Control[4][n25];
        for (n24 = 0; n24 < n27; ++n24) {
            Control control2 = controlArray2[n24];
            object = (GridData)control2.getLayoutData();
            int n30 = Math.max(1, Math.min(((GridData)object).horizontalSpan, n25));
            int n31 = Math.max(1, ((GridData)object).verticalSpan);
            while (true) {
                if ((n23 = n26 + n31) >= controlArray.length) {
                    Control[][] controlArray3 = new Control[n23 + 4][n25];
                    System.arraycopy(controlArray, 0, controlArray3, 0, controlArray.length);
                    controlArray = controlArray3;
                }
                if (controlArray[n26] == null) {
                    controlArray[n26] = new Control[n25];
                }
                while (n28 < n25 && controlArray[n26][n28] != null) {
                    ++n28;
                }
                n22 = n28 + n30;
                if (n22 <= n25) {
                    int n32;
                    for (n32 = n28; n32 < n22 && controlArray[n26][n32] == null; ++n32) {
                    }
                    if (n32 == n22) break;
                    n28 = n32;
                }
                if (n28 + n30 < n25) continue;
                n28 = 0;
                ++n26;
            }
            for (n23 = 0; n23 < n31; ++n23) {
                if (controlArray[n26 + n23] == null) {
                    controlArray[n26 + n23] = new Control[n25];
                }
                for (n22 = 0; n22 < n30; ++n22) {
                    controlArray[n26 + n23][n28 + n22] = control2;
                }
            }
            n29 = Math.max(n29, n26 + n31);
            n28 += n30;
        }
        n24 = n4 - this.horizontalSpacing * (n25 - 1) - (this.marginLeft + this.marginWidth * 2 + this.marginRight);
        int n33 = 0;
        object = new int[n25];
        int[] nArray = new int[n25];
        boolean[] blArray = new boolean[n25];
        for (n23 = 0; n23 < n25; ++n23) {
            GridData gridData2;
            for (n22 = 0; n22 < n29; ++n22) {
                gridData2 = this.getData(controlArray, n22, n23, n29, n25, true);
                if (gridData2 == null || (n21 = Math.max(1, Math.min(gridData2.horizontalSpan, n25))) != 1) continue;
                n20 = gridData2.cacheWidth + gridData2.horizontalIndent;
                object[n23] = Math.max((int)object[n23], n20);
                if (gridData2.grabExcessHorizontalSpace) {
                    if (!blArray[n23]) {
                        ++n33;
                    }
                    blArray[n23] = true;
                }
                if (gridData2.grabExcessHorizontalSpace && gridData2.minimumWidth == 0) continue;
                n20 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                nArray[n23] = Math.max(nArray[n23], n20 += gridData2.horizontalIndent);
            }
            for (n22 = 0; n22 < n29; ++n22) {
                int n34;
                gridData2 = this.getData(controlArray, n22, n23, n29, n25, false);
                if (gridData2 == null || (n21 = Math.max(1, Math.min(gridData2.horizontalSpan, n25))) <= 1) continue;
                n20 = 0;
                n19 = 0;
                n18 = 0;
                for (n34 = 0; n34 < n21; ++n34) {
                    n20 += object[n23 - n34];
                    n19 += nArray[n23 - n34];
                    if (!blArray[n23 - n34]) continue;
                    ++n18;
                }
                if (gridData2.grabExcessHorizontalSpace && n18 == 0) {
                    ++n33;
                    blArray[n23] = true;
                }
                if ((n34 = gridData2.cacheWidth + gridData2.horizontalIndent - n20 - (n21 - 1) * this.horizontalSpacing) > 0) {
                    if (this.makeColumnsEqualWidth) {
                        n17 = (n34 + n20) / n21;
                        n16 = (n34 + n20) % n21;
                        n15 = -1;
                        for (n14 = 0; n14 < n21; ++n14) {
                            n15 = n23 - n14;
                            object[n15] = Math.max(n17, (int)object[n23 - n14]);
                        }
                        if (n15 > -1) {
                            Object object2 = object;
                            int n35 = n15;
                            object2[n35] = object2[n35] + n16;
                        }
                    } else if (n18 == 0) {
                        Object object3 = object;
                        int n36 = n23;
                        object3[n36] = object3[n36] + n34;
                    } else {
                        n17 = n34 / n18;
                        n16 = n34 % n18;
                        n15 = -1;
                        for (n14 = 0; n14 < n21; ++n14) {
                            if (!blArray[n23 - n14]) continue;
                            Object object4 = object;
                            n15 = n23 - n14;
                            object4[n15] = object4[n15] + n17;
                        }
                        if (n15 > -1) {
                            Object object5 = object;
                            int n37 = n15;
                            object5[n37] = object5[n37] + n16;
                        }
                    }
                }
                if (gridData2.grabExcessHorizontalSpace && gridData2.minimumWidth == 0) continue;
                int n38 = n34 = !gridData2.grabExcessHorizontalSpace || gridData2.minimumWidth == -1 ? gridData2.cacheWidth : gridData2.minimumWidth;
                if ((n34 += gridData2.horizontalIndent - n19 - (n21 - 1) * this.horizontalSpacing) <= 0) continue;
                if (n18 == 0) {
                    int n39 = n23;
                    nArray[n39] = nArray[n39] + n34;
                    continue;
                }
                n17 = n34 / n18;
                n16 = n34 % n18;
                n15 = -1;
                for (n14 = 0; n14 < n21; ++n14) {
                    if (!blArray[n23 - n14]) continue;
                    n15 = n23 - n14;
                    nArray[n15] = nArray[n15] + n17;
                }
                if (n15 <= -1) continue;
                int n40 = n15;
                nArray[n40] = nArray[n40] + n16;
            }
        }
        if (this.makeColumnsEqualWidth) {
            int n41;
            n23 = 0;
            n22 = 0;
            for (n41 = 0; n41 < n25; ++n41) {
                n23 = Math.max(n23, nArray[n41]);
                n22 = Math.max(n22, (int)object[n41]);
            }
            n22 = n4 == -1 || n33 == 0 ? n22 : Math.max(n23, n24 / n25);
            for (n41 = 0; n41 < n25; ++n41) {
                blArray[n41] = n33 > 0;
                object[n41] = n22;
            }
        } else if (n4 != -1 && n33 > 0) {
            n23 = 0;
            for (n22 = 0; n22 < n25; ++n22) {
                n23 += object[n22];
            }
            n22 = n33;
            int n42 = (n24 - n23) / n22;
            n21 = (n24 - n23) % n22;
            n20 = -1;
            while (n23 != n24) {
                for (n19 = 0; n19 < n25; ++n19) {
                    if (!blArray[n19]) continue;
                    if (object[n19] + n42 > nArray[n19]) {
                        n20 = n19;
                        object[n20] = object[n19] + n42;
                        continue;
                    }
                    object[n19] = nArray[n19];
                    blArray[n19] = false;
                    --n22;
                }
                if (n20 > -1) {
                    Object object6 = object;
                    int n43 = n20;
                    object6[n43] = object6[n43] + n21;
                }
                for (n19 = 0; n19 < n25; ++n19) {
                    for (n18 = 0; n18 < n29; ++n18) {
                        GridData gridData3 = this.getData(controlArray, n18, n19, n29, n25, false);
                        if (gridData3 == null || (n17 = Math.max(1, Math.min(gridData3.horizontalSpan, n25))) <= 1 || gridData3.grabExcessHorizontalSpace && gridData3.minimumWidth == 0) continue;
                        n16 = 0;
                        n15 = 0;
                        for (n14 = 0; n14 < n17; ++n14) {
                            n16 += object[n19 - n14];
                            if (!blArray[n19 - n14]) continue;
                            ++n15;
                        }
                        int n44 = n14 = !gridData3.grabExcessHorizontalSpace || gridData3.minimumWidth == -1 ? gridData3.cacheWidth : gridData3.minimumWidth;
                        if ((n14 += gridData3.horizontalIndent - n16 - (n17 - 1) * this.horizontalSpacing) <= 0) continue;
                        if (n15 == 0) {
                            Object object7 = object;
                            int n45 = n19;
                            object7[n45] = object7[n45] + n14;
                            continue;
                        }
                        n13 = n14 / n15;
                        n12 = n14 % n15;
                        n11 = -1;
                        for (n10 = 0; n10 < n17; ++n10) {
                            if (!blArray[n19 - n10]) continue;
                            Object object8 = object;
                            n11 = n19 - n10;
                            object8[n11] = object8[n11] + n13;
                        }
                        if (n11 <= -1) continue;
                        Object object9 = object;
                        int n46 = n11;
                        object9[n46] = object9[n46] + n12;
                    }
                }
                if (n22 != 0) {
                    n23 = 0;
                    for (n19 = 0; n19 < n25; ++n19) {
                        n23 += object[n19];
                    }
                    n42 = (n24 - n23) / n22;
                    n21 = (n24 - n23) % n22;
                    n20 = -1;
                    continue;
                }
                break;
            }
        }
        GridData[] gridDataArray = null;
        n22 = 0;
        if (n4 != -1) {
            for (int i2 = 0; i2 < n25; ++i2) {
                for (n21 = 0; n21 < n29; ++n21) {
                    GridData gridData4 = this.getData(controlArray, n21, i2, n29, n25, false);
                    if (gridData4 == null || gridData4.heightHint != -1) continue;
                    Control control3 = controlArray[n21][i2];
                    n18 = Math.max(1, Math.min(gridData4.horizontalSpan, n25));
                    int n47 = 0;
                    for (n17 = 0; n17 < n18; ++n17) {
                        n47 += object[i2 - n17];
                    }
                    if (((n47 += (n18 - 1) * this.horizontalSpacing - gridData4.horizontalIndent) == gridData4.cacheWidth || gridData4.horizontalAlignment != 4) && gridData4.cacheWidth <= n47) continue;
                    n17 = 0;
                    if (control3 instanceof Scrollable) {
                        Rectangle rectangle = ((Scrollable)control3).computeTrim(0, 0, 0, 0);
                        n17 = rectangle.width;
                    } else {
                        n17 = control3.getBorderWidth() * 2;
                    }
                    gridData4.cacheHeight = -1;
                    gridData4.cacheWidth = -1;
                    gridData4.computeSize(control3, Math.max(0, n47 - n17), gridData4.heightHint, false);
                    if (gridData4.grabExcessVerticalSpace && gridData4.minimumHeight > 0) {
                        gridData4.cacheHeight = Math.max(gridData4.cacheHeight, gridData4.minimumHeight);
                    }
                    if (gridDataArray == null) {
                        gridDataArray = new GridData[n27];
                    }
                    gridDataArray[n22++] = gridData4;
                }
            }
        }
        int n48 = n5 - this.verticalSpacing * (n29 - 1) - (this.marginTop + this.marginHeight * 2 + this.marginBottom);
        n33 = 0;
        int[] nArray2 = new int[n29];
        int[] nArray3 = new int[n29];
        boolean[] blArray2 = new boolean[n29];
        for (n18 = 0; n18 < n29; ++n18) {
            int n49;
            GridData gridData5;
            int n50;
            for (n50 = 0; n50 < n25; ++n50) {
                gridData5 = this.getData(controlArray, n18, n50, n29, n25, true);
                if (gridData5 == null || (n49 = Math.max(1, Math.min(gridData5.verticalSpan, n29))) != 1) continue;
                n15 = gridData5.cacheHeight + gridData5.verticalIndent;
                nArray2[n18] = Math.max(nArray2[n18], n15);
                if (gridData5.grabExcessVerticalSpace) {
                    if (!blArray2[n18]) {
                        ++n33;
                    }
                    blArray2[n18] = true;
                }
                if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight == 0) continue;
                n15 = !gridData5.grabExcessVerticalSpace || gridData5.minimumHeight == -1 ? gridData5.cacheHeight : gridData5.minimumHeight;
                nArray3[n18] = Math.max(nArray3[n18], n15 += gridData5.verticalIndent);
            }
            for (n50 = 0; n50 < n25; ++n50) {
                gridData5 = this.getData(controlArray, n18, n50, n29, n25, false);
                if (gridData5 == null || (n49 = Math.max(1, Math.min(gridData5.verticalSpan, n29))) <= 1) continue;
                n15 = 0;
                n14 = 0;
                n13 = 0;
                for (n12 = 0; n12 < n49; ++n12) {
                    n15 += nArray2[n18 - n12];
                    n14 += nArray3[n18 - n12];
                    if (!blArray2[n18 - n12]) continue;
                    ++n13;
                }
                if (gridData5.grabExcessVerticalSpace && n13 == 0) {
                    ++n33;
                    blArray2[n18] = true;
                }
                if ((n12 = gridData5.cacheHeight + gridData5.verticalIndent - n15 - (n49 - 1) * this.verticalSpacing) > 0) {
                    if (n13 == 0) {
                        int n51 = n18;
                        nArray2[n51] = nArray2[n51] + n12;
                    } else {
                        n11 = n12 / n13;
                        n10 = n12 % n13;
                        n9 = -1;
                        for (n8 = 0; n8 < n49; ++n8) {
                            if (!blArray2[n18 - n8]) continue;
                            n9 = n18 - n8;
                            nArray2[n9] = nArray2[n9] + n11;
                        }
                        if (n9 > -1) {
                            int n52 = n9;
                            nArray2[n52] = nArray2[n52] + n10;
                        }
                    }
                }
                if (gridData5.grabExcessVerticalSpace && gridData5.minimumHeight == 0) continue;
                int n53 = n12 = !gridData5.grabExcessVerticalSpace || gridData5.minimumHeight == -1 ? gridData5.cacheHeight : gridData5.minimumHeight;
                if ((n12 += gridData5.verticalIndent - n14 - (n49 - 1) * this.verticalSpacing) <= 0) continue;
                if (n13 == 0) {
                    int n54 = n18;
                    nArray3[n54] = nArray3[n54] + n12;
                    continue;
                }
                n11 = n12 / n13;
                n10 = n12 % n13;
                n9 = -1;
                for (n8 = 0; n8 < n49; ++n8) {
                    if (!blArray2[n18 - n8]) continue;
                    n9 = n18 - n8;
                    nArray3[n9] = nArray3[n9] + n11;
                }
                if (n9 <= -1) continue;
                int n55 = n9;
                nArray3[n55] = nArray3[n55] + n10;
            }
        }
        if (n5 != -1 && n33 > 0) {
            int n56;
            n18 = 0;
            for (n56 = 0; n56 < n29; ++n56) {
                n18 += nArray2[n56];
            }
            n56 = n33;
            int n57 = (n48 - n18) / n56;
            int n58 = (n48 - n18) % n56;
            n15 = -1;
            while (n18 != n48) {
                for (n14 = 0; n14 < n29; ++n14) {
                    if (!blArray2[n14]) continue;
                    if (nArray2[n14] + n57 > nArray3[n14]) {
                        n15 = n14;
                        nArray2[n15] = nArray2[n14] + n57;
                        continue;
                    }
                    nArray2[n14] = nArray3[n14];
                    blArray2[n14] = false;
                    --n56;
                }
                if (n15 > -1) {
                    int n59 = n15;
                    nArray2[n59] = nArray2[n59] + n58;
                }
                for (n14 = 0; n14 < n29; ++n14) {
                    for (n13 = 0; n13 < n25; ++n13) {
                        GridData gridData6 = this.getData(controlArray, n14, n13, n29, n25, false);
                        if (gridData6 == null || (n11 = Math.max(1, Math.min(gridData6.verticalSpan, n29))) <= 1 || gridData6.grabExcessVerticalSpace && gridData6.minimumHeight == 0) continue;
                        n10 = 0;
                        n9 = 0;
                        for (n8 = 0; n8 < n11; ++n8) {
                            n10 += nArray2[n14 - n8];
                            if (!blArray2[n14 - n8]) continue;
                            ++n9;
                        }
                        int n60 = n8 = !gridData6.grabExcessVerticalSpace || gridData6.minimumHeight == -1 ? gridData6.cacheHeight : gridData6.minimumHeight;
                        if ((n8 += gridData6.verticalIndent - n10 - (n11 - 1) * this.verticalSpacing) <= 0) continue;
                        if (n9 == 0) {
                            int n61 = n14;
                            nArray2[n61] = nArray2[n61] + n8;
                            continue;
                        }
                        n7 = n8 / n9;
                        int n62 = n8 % n9;
                        int n63 = -1;
                        for (int i3 = 0; i3 < n11; ++i3) {
                            if (!blArray2[n14 - i3]) continue;
                            n63 = n14 - i3;
                            nArray2[n63] = nArray2[n63] + n7;
                        }
                        if (n63 <= -1) continue;
                        int n64 = n63;
                        nArray2[n64] = nArray2[n64] + n62;
                    }
                }
                if (n56 == 0) break;
                n18 = 0;
                for (n14 = 0; n14 < n29; ++n14) {
                    n18 += nArray2[n14];
                }
                n57 = (n48 - n18) / n56;
                n58 = (n48 - n18) % n56;
                n15 = -1;
            }
        }
        if (bl2) {
            n18 = n3 + this.marginTop + this.marginHeight;
            for (int i4 = 0; i4 < n29; ++i4) {
                int n65 = n2 + this.marginLeft + this.marginWidth;
                for (int i5 = 0; i5 < n25; ++i5) {
                    GridData gridData7 = this.getData(controlArray, i4, i5, n29, n25, true);
                    if (gridData7 != null) {
                        n14 = Math.max(1, Math.min(gridData7.horizontalSpan, n25));
                        n13 = Math.max(1, gridData7.verticalSpan);
                        int n66 = 0;
                        n11 = 0;
                        for (n10 = 0; n10 < n14; ++n10) {
                            n66 += object[i5 + n10];
                        }
                        for (n10 = 0; n10 < n13; ++n10) {
                            n11 += nArray2[i4 + n10];
                        }
                        n10 = n65 + gridData7.horizontalIndent;
                        n9 = Math.min(gridData7.cacheWidth, n66 += this.horizontalSpacing * (n14 - 1));
                        switch (gridData7.horizontalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n10 += Math.max(0, (n66 - gridData7.horizontalIndent - n9) / 2);
                                break;
                            }
                            case 3: 
                            case 131072: 
                            case 0x1000008: {
                                n10 += Math.max(0, n66 - gridData7.horizontalIndent - n9);
                                break;
                            }
                            case 4: {
                                n9 = n66 - gridData7.horizontalIndent;
                            }
                        }
                        n8 = n18 + gridData7.verticalIndent;
                        n7 = Math.min(gridData7.cacheHeight, n11 += this.verticalSpacing * (n13 - 1));
                        switch (gridData7.verticalAlignment) {
                            case 2: 
                            case 0x1000000: {
                                n8 += Math.max(0, (n11 - gridData7.verticalIndent - n7) / 2);
                                break;
                            }
                            case 3: 
                            case 1024: 
                            case 0x1000008: {
                                n8 += Math.max(0, n11 - gridData7.verticalIndent - n7);
                                break;
                            }
                            case 4: {
                                n7 = n11 - gridData7.verticalIndent;
                            }
                        }
                        Control control4 = controlArray[i4][i5];
                        if (control4 != null) {
                            control4.setBounds(n10, n8, n9, n7);
                        }
                    }
                    n65 += object[i5] + this.horizontalSpacing;
                }
                n18 += nArray2[i4] + this.verticalSpacing;
            }
        }
        for (n18 = 0; n18 < n22; ++n18) {
            gridDataArray[n18].cacheHeight = -1;
            gridDataArray[n18].cacheWidth = -1;
        }
        n18 = 0;
        int n67 = 0;
        for (n6 = 0; n6 < n25; ++n6) {
            n18 += object[n6];
        }
        for (n6 = 0; n6 < n29; ++n6) {
            n67 += nArray2[n6];
        }
        return new Point(n18 += this.horizontalSpacing * (n25 - 1) + this.marginLeft + this.marginWidth * 2 + this.marginRight, n67 += this.verticalSpacing * (n29 - 1) + this.marginTop + this.marginHeight * 2 + this.marginBottom);
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    public String toString() {
        String string = this.getName() + " {";
        if (this.numColumns != 1) {
            string = string + "numColumns=" + this.numColumns + " ";
        }
        if (this.makeColumnsEqualWidth) {
            string = string + "makeColumnsEqualWidth=" + this.makeColumnsEqualWidth + " ";
        }
        if (this.marginWidth != 0) {
            string = string + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = string + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.marginLeft != 0) {
            string = string + "marginLeft=" + this.marginLeft + " ";
        }
        if (this.marginRight != 0) {
            string = string + "marginRight=" + this.marginRight + " ";
        }
        if (this.marginTop != 0) {
            string = string + "marginTop=" + this.marginTop + " ";
        }
        if (this.marginBottom != 0) {
            string = string + "marginBottom=" + this.marginBottom + " ";
        }
        if (this.horizontalSpacing != 0) {
            string = string + "horizontalSpacing=" + this.horizontalSpacing + " ";
        }
        if (this.verticalSpacing != 0) {
            string = string + "verticalSpacing=" + this.verticalSpacing + " ";
        }
        string = string.trim();
        string = string + "}";
        return string;
    }
}

