/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bridj.BridJ;
import org.bridj.NativeLibrary;
import org.bridj.Platform$1;
import org.bridj.Platform$2;
import org.bridj.Platform$DeleteFiles;
import org.bridj.util.ProcessUtils;
import org.bridj.util.StringUtils;

public class Platform {
    static final String osName = System.getProperty("os.name", "");
    private static boolean inited;
    static final String BridJLibraryName = "bridj";
    public static final int POINTER_SIZE;
    public static final int WCHAR_T_SIZE;
    public static final int SIZE_T_SIZE;
    public static final int TIME_T_SIZE;
    public static final int CLONG_SIZE;
    static final ClassLoader systemClassLoader;
    static final List embeddedLibraryResourceRoots;
    static Set temporaryExtractedLibraryCanonicalFiles;
    private static final String arch;
    private static boolean is64Bits;
    private static File extractedLibrariesTempDir;
    private static List nativeLibraries;
    public static boolean useUnicodeVersionOfWindowsAPIs;
    static final long DELETE_OLD_BINARIES_AFTER_MILLIS = 86400000L;
    static final int maxTempFileAttempts = 20;

    public static ClassLoader getClassLoader() {
        return Platform.getClassLoader(BridJ.class);
    }

    public static ClassLoader getClassLoader(Class clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader classLoader2 = clazz == null ? null : clazz.getClassLoader();
        return classLoader2 == null ? systemClassLoader : classLoader2;
    }

    public static InputStream getResourceAsStream(String string) {
        URL uRL = Platform.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            if (BridJ.verbose) {
                BridJ.warning("Failed to get resource '" + string + "'", iOException);
            }
            return null;
        }
    }

    public static URL getResource(String string) {
        ClassLoader[] classLoaderArray;
        URL uRL;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if ((uRL = BridJ.class.getResource(string)) != null) {
            return uRL;
        }
        for (ClassLoader classLoader : classLoaderArray = new ClassLoader[]{BridJ.class.getClassLoader(), Thread.currentThread().getContextClassLoader(), systemClassLoader}) {
            if (classLoader == null || (uRL = classLoader.getResource(string)) == null) continue;
            return uRL;
        }
        return null;
    }

    public static synchronized void addEmbeddedLibraryResourceRoot(String string) {
        embeddedLibraryResourceRoots.add(0, string);
    }

    static void addTemporaryExtractedLibraryFileToDeleteOnExit(File file) throws IOException {
        File file2 = file.getCanonicalFile();
        temporaryExtractedLibraryCanonicalFiles.add(file2);
        file2.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addNativeLibrary(NativeLibrary nativeLibrary) {
        List list2 = nativeLibraries;
        synchronized (list2) {
            nativeLibraries.add(nativeLibrary);
        }
    }

    private static void shutdown() {
        Platform.deleteTemporaryExtractedLibraryFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseNativeLibraries() {
        List list2 = nativeLibraries;
        synchronized (list2) {
            int n2 = nativeLibraries.size();
            while (n2-- != 0) {
                NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraries.get(n2);
                try {
                    nativeLibrary.release();
                }
                catch (Throwable throwable) {
                    BridJ.error("Failed to release library '" + nativeLibrary.path + "' : " + throwable, throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteTemporaryExtractedLibraryFiles() {
        Set set = temporaryExtractedLibraryCanonicalFiles;
        synchronized (set) {
            temporaryExtractedLibraryCanonicalFiles.add(extractedLibrariesTempDir);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file : temporaryExtractedLibraryCanonicalFiles) {
                if (file.delete()) {
                    if (!BridJ.verbose) continue;
                    BridJ.info("Deleted temporary library file '" + file + "'");
                    continue;
                }
                arrayList.add(file);
            }
            if (!arrayList.isEmpty()) {
                if (BridJ.verbose) {
                    BridJ.info("Attempting to delete " + arrayList.size() + " files after JVM exit : " + StringUtils.implode(arrayList, (Object)", "));
                }
                try {
                    ProcessUtils.startJavaProcess(Platform$DeleteFiles.class, arrayList);
                }
                catch (Throwable throwable) {
                    BridJ.error("Failed to launch process to delete files after JVM exit : " + throwable, throwable);
                }
            }
        }
    }

    static ClassLoader createClassLoader() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string : new String[]{"java.class.path", "sun.boot.class.path"}) {
            String string2 = System.getProperty(string);
            if (string2 == null) continue;
            for (String string3 : string2.split(File.pathSeparator)) {
                URL uRL;
                if ((string3 = string3.trim()).length() == 0) continue;
                try {
                    uRL = new URL(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        uRL = new File(string3).toURI().toURL();
                    }
                    catch (MalformedURLException malformedURLException2) {
                        uRL = null;
                    }
                }
                if (uRL == null) continue;
                arrayList.add(uRL);
            }
        }
        return new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
    }

    static String getenvOrProperty(String string, String string2, String string3) {
        String string4 = System.getenv(string);
        if (string4 == null) {
            string4 = System.getProperty(string2);
        }
        if (string4 == null) {
            string4 = string3;
        }
        return string4;
    }

    public static synchronized void initLibrary() {
        if (inited) {
            return;
        }
        inited = true;
        try {
            boolean bl2 = false;
            String string = Platform.getenvOrProperty("BRIDJ_LIBRARY", "bridj.library", null);
            String string2 = null;
            if (string != null) {
                try {
                    string2 = string;
                    System.load(string2);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    BridJ.error("Failed to load forced library " + string, throwable);
                }
            }
            if (!bl2) {
                if (!Platform.isAndroid()) {
                    try {
                        File file = Platform.extractEmbeddedLibraryResource(BridJLibraryName);
                        if (file == null) {
                            throw new FileNotFoundException("Failed to extract embedded library 'bridj' (could be a classloader issue, or missing binary in resource path " + StringUtils.implode(embeddedLibraryResourceRoots, (Object)", ") + ")");
                        }
                        if (BridJ.veryVerbose) {
                            BridJ.info("Loading library " + file);
                        }
                        string2 = file.toString();
                        System.load(string2);
                        BridJ.setNativeLibraryFile(BridJLibraryName, file);
                        bl2 = true;
                    }
                    catch (IOException iOException) {
                        BridJ.error("Failed to load 'bridj'", iOException);
                    }
                }
                if (!bl2) {
                    System.loadLibrary(BridJLibraryName);
                }
            }
            if (BridJ.veryVerbose) {
                BridJ.info("Loaded library " + string2);
            }
            Platform.init();
            if (BridJ.logCalls) {
                BridJ.info("Calls logs enabled");
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to initialize " + BridJ.class.getSimpleName() + " (" + throwable + ")", throwable);
        }
    }

    private static native void init();

    public static boolean isLinux() {
        return Platform.isUnix() && osName.toLowerCase().contains("linux");
    }

    public static boolean isMacOSX() {
        return Platform.isUnix() && (osName.startsWith("Mac") || osName.startsWith("Darwin"));
    }

    public static boolean isSolaris() {
        return Platform.isUnix() && (osName.startsWith("SunOS") || osName.startsWith("Solaris"));
    }

    public static boolean isBSD() {
        return Platform.isUnix() && (osName.contains("BSD") || Platform.isMacOSX());
    }

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isWindows7() {
        return osName.equals("Windows 7");
    }

    private static String getArch() {
        return arch;
    }

    public static String getMachine() {
        String string = Platform.getArch();
        if (string.equals("amd64") || string.equals("x86_64")) {
            if (Platform.is64Bits()) {
                return "x86_64";
            }
            return "i386";
        }
        return string;
    }

    public static boolean isAndroid() {
        return "dalvik".equalsIgnoreCase(System.getProperty("java.vm.name")) && Platform.isLinux();
    }

    public static boolean isArm() {
        String string = Platform.getArch();
        return "arm".equals(string);
    }

    public static boolean isSparc() {
        String string = Platform.getArch();
        return "sparc".equals(string) || "sparcv9".equals(string);
    }

    public static boolean is64Bits() {
        return is64Bits;
    }

    public static boolean isAmd64Arch() {
        String string = Platform.getArch();
        return string.equals("x86_64");
    }

    static List getPossibleFileNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        if (Platform.isWindows()) {
            arrayList.add(string + ".dll");
            arrayList.add(string + ".drv");
        } else {
            String string2 = "lib" + string + ".jnilib";
            if (Platform.isMacOSX()) {
                arrayList.add("lib" + string + ".dylib");
                arrayList.add(string2);
            } else {
                arrayList.add("lib" + string + ".so");
                arrayList.add(string + ".so");
                arrayList.add(string2);
            }
        }
        assert (!arrayList.isEmpty());
        if (string.contains(".")) {
            arrayList.add(string);
        }
        return arrayList;
    }

    static synchronized List getEmbeddedLibraryPaths(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(embeddedLibraryResourceRoots.size());
        for (String string2 : embeddedLibraryResourceRoots) {
            if (string2 == null) continue;
            if (Platform.isWindows()) {
                arrayList.add(string2 + (Platform.is64Bits() ? "win64/" : "win32/"));
                continue;
            }
            if (Platform.isMacOSX()) {
                if (Platform.isArm()) {
                    arrayList.add(string2 + "iphoneos_arm32_arm/");
                    continue;
                }
                arrayList.add(string2 + "darwin_universal/");
                if (!Platform.isAmd64Arch()) continue;
                arrayList.add(string2 + "darwin_x64/");
                continue;
            }
            if (Platform.isAndroid()) {
                assert (string2.equals("libs/"));
                arrayList.add(string2 + "armeabi/");
                continue;
            }
            if (Platform.isLinux()) {
                if (Platform.isArm()) {
                    arrayList.add(string2 + "linux_armhf/");
                    continue;
                }
                arrayList.add(string2 + (Platform.is64Bits() ? "linux_x64/" : "linux_x86/"));
                continue;
            }
            if (!Platform.isSolaris()) continue;
            if (Platform.isSparc()) {
                arrayList.add(string2 + (Platform.is64Bits() ? "sunos_sparc64/" : "sunos_sparc/"));
                continue;
            }
            arrayList.add(string2 + (Platform.is64Bits() ? "sunos_x64/" : "sunos_x86/"));
        }
        if (arrayList.isEmpty()) {
            throw new RuntimeException("Platform not supported ! (os.name='" + osName + "', os.arch='" + System.getProperty("os.arch") + "')");
        }
        return arrayList;
    }

    static synchronized List getEmbeddedLibraryResource(String string) {
        List list2 = Platform.getEmbeddedLibraryPaths(string);
        List list3 = Platform.getPossibleFileNames(string);
        ArrayList<String> arrayList = new ArrayList<String>(list2.size() * list3.size());
        for (String string2 : list2) {
            for (String string3 : list3) {
                arrayList.add(string2 + string3);
            }
        }
        if (BridJ.veryVerbose) {
            BridJ.info("Embedded resource paths for library '" + string + "': " + arrayList);
        }
        return arrayList;
    }

    static void tryDeleteFilesInSameDirectory(File file, Pattern pattern, long l2) {
        long l3 = System.currentTimeMillis() - l2;
        new Thread(new Platform$2(file, pattern, l3)).start();
    }

    static File extractEmbeddedLibraryResource(String string) throws IOException {
        String string2 = null;
        List list2 = Platform.getEmbeddedLibraryResource(string);
        if (BridJ.veryVerbose) {
            BridJ.info("Library resources for " + string + ": " + list2);
        }
        for (String string3 : list2) {
            int n2;
            Object object;
            if (string2 == null) {
                string2 = string3;
            }
            int n3 = string3.lastIndexOf(46);
            byte[] byArray = new byte[8196];
            InputStream inputStream = Platform.getResourceAsStream(string3);
            if (inputStream == null) {
                object = new File(string3);
                if (!((File)object).exists()) {
                    object = new File(((File)object).getName());
                }
                if (!((File)object).exists()) continue;
                return ((File)object).getCanonicalFile();
            }
            object = new File(string3).getName();
            File file = new File(extractedLibrariesTempDir, (String)object);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
            }
            ((OutputStream)bufferedOutputStream).close();
            inputStream.close();
            Platform.addTemporaryExtractedLibraryFileToDeleteOnExit(file);
            Platform.addTemporaryExtractedLibraryFileToDeleteOnExit(file.getParentFile());
            return file;
        }
        return null;
    }

    static File createTempDir(String string) throws IOException {
        for (int i2 = 0; i2 < 20; ++i2) {
            File file = File.createTempFile(string, "");
            if (!file.delete() || !file.mkdirs()) continue;
            return file;
        }
        throw new RuntimeException("Failed to create temp dir with prefix '" + string + "' despite " + 20 + " attempts!");
    }

    public static final void open(URL uRL) throws NoSuchMethodException {
        if (uRL.getProtocol().equals("file")) {
            Platform.open(new File(uRL.getFile()));
        } else if (Platform.isMacOSX()) {
            Platform.execArgs("open", uRL.toString());
        } else if (Platform.isWindows()) {
            Platform.execArgs("rundll32", "url.dll,FileProtocolHandler", uRL.toString());
        } else if (Platform.isUnix() && Platform.hasUnixCommand("gnome-open")) {
            Platform.execArgs("gnome-open", uRL.toString());
        } else if (Platform.isUnix() && Platform.hasUnixCommand("konqueror")) {
            Platform.execArgs("konqueror", uRL.toString());
        } else if (Platform.isUnix() && Platform.hasUnixCommand("mozilla")) {
            Platform.execArgs("mozilla", uRL.toString());
        } else {
            throw new NoSuchMethodException("Cannot open urls on this platform");
        }
    }

    public static final void open(File file) throws NoSuchMethodException {
        if (Platform.isMacOSX()) {
            Platform.execArgs("open", file.getAbsolutePath());
        } else if (Platform.isWindows()) {
            if (file.isDirectory()) {
                Platform.execArgs("explorer", file.getAbsolutePath());
            } else {
                Platform.execArgs("start", file.getAbsolutePath());
            }
        } else if (Platform.isUnix() && Platform.hasUnixCommand("gnome-open")) {
            Platform.execArgs("gnome-open", file.toString());
        } else if (Platform.isUnix() && Platform.hasUnixCommand("konqueror")) {
            Platform.execArgs("konqueror", file.toString());
        } else if (Platform.isSolaris() && file.isDirectory()) {
            Platform.execArgs("/usr/dt/bin/dtfile", "-folder", file.getAbsolutePath());
        } else {
            throw new NoSuchMethodException("Cannot open files on this platform");
        }
    }

    public static final void show(File file) throws NoSuchMethodException, IOException {
        if (Platform.isWindows()) {
            Platform.exec("explorer /e,/select,\"" + file.getCanonicalPath() + "\"");
        } else {
            Platform.open(file.getAbsoluteFile().getParentFile());
        }
    }

    static final void execArgs(String ... stringArray) throws NoSuchMethodException {
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NoSuchMethodException(exception.toString());
        }
    }

    static final void exec(String string) throws NoSuchMethodException {
        try {
            Runtime.getRuntime().exec(string).waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NoSuchMethodException(exception.toString());
        }
    }

    static final boolean hasUnixCommand(String string) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", string});
            return process.waitFor() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    static native int sizeOf_size_t();

    static native int sizeOf_time_t();

    static native int sizeOf_wchar_t();

    static native int sizeOf_ptrdiff_t();

    static native int sizeOf_long();

    static native int getMaxDirectMappingArgCount();

    static /* synthetic */ void access$000() {
        Platform.shutdown();
    }

    static {
        embeddedLibraryResourceRoots = new ArrayList();
        temporaryExtractedLibraryCanonicalFiles = Collections.synchronizedSet(new LinkedHashSet());
        arch = System.getProperty("os.arch");
        String string = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        is64Bits = "32".equals(string) ? false : ("64".equals(string) ? true : arch.contains("64") || arch.equalsIgnoreCase("sparcv9"));
        systemClassLoader = Platform.createClassLoader();
        Platform.addEmbeddedLibraryResourceRoot("libs/");
        if (!Platform.isAndroid()) {
            Platform.addEmbeddedLibraryResourceRoot("lib/");
            Platform.addEmbeddedLibraryResourceRoot("org/bridj/lib/");
            if (!"v0_7_0".equals("")) {
                Platform.addEmbeddedLibraryResourceRoot("org/bridj/v0_7_0/lib/");
            }
        }
        try {
            extractedLibrariesTempDir = Platform.createTempDir("BridJExtractedLibraries");
            Platform.initLibrary();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        POINTER_SIZE = Platform.sizeOf_ptrdiff_t();
        WCHAR_T_SIZE = Platform.sizeOf_wchar_t();
        SIZE_T_SIZE = Platform.sizeOf_size_t();
        TIME_T_SIZE = Platform.sizeOf_time_t();
        CLONG_SIZE = Platform.sizeOf_long();
        is64Bits = POINTER_SIZE == 8;
        Runtime.getRuntime().addShutdownHook(new Platform$1());
        nativeLibraries = new ArrayList();
        useUnicodeVersionOfWindowsAPIs = !"false".equals(System.getProperty("bridj.useUnicodeVersionOfWindowsAPIs")) && !"0".equals(System.getenv("BRIDJ_USE_UNICODE_VERSION_OF_WINDOWS_APIS"));
    }
}

