/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.LinuxAxisDescriptor;
import net.java.games.input.LinuxComponent;
import net.java.games.input.LinuxControllers;
import net.java.games.input.LinuxEnvironmentPlugin;
import net.java.games.input.LinuxEventComponent;

final class LinuxPOV
extends LinuxComponent {
    private final LinuxEventComponent component_x;
    private final LinuxEventComponent component_y;
    private float last_x;
    private float last_y;

    public LinuxPOV(LinuxEventComponent linuxEventComponent, LinuxEventComponent linuxEventComponent2) {
        super(linuxEventComponent);
        this.component_x = linuxEventComponent;
        this.component_y = linuxEventComponent2;
    }

    @Override
    protected final float poll() throws IOException {
        this.last_x = LinuxControllers.poll(this.component_x);
        this.last_y = LinuxControllers.poll(this.component_y);
        return this.convertValue(0.0f, null);
    }

    @Override
    public float convertValue(float f2, LinuxAxisDescriptor linuxAxisDescriptor) {
        if (linuxAxisDescriptor == this.component_x.getDescriptor()) {
            this.last_x = f2;
        }
        if (linuxAxisDescriptor == this.component_y.getDescriptor()) {
            this.last_y = f2;
        }
        if (this.last_x == -1.0f && this.last_y == -1.0f) {
            return 0.125f;
        }
        if (this.last_x == -1.0f && this.last_y == 0.0f) {
            return 1.0f;
        }
        if (this.last_x == -1.0f && this.last_y == 1.0f) {
            return 0.875f;
        }
        if (this.last_x == 0.0f && this.last_y == -1.0f) {
            return 0.25f;
        }
        if (this.last_x == 0.0f && this.last_y == 0.0f) {
            return 0.0f;
        }
        if (this.last_x == 0.0f && this.last_y == 1.0f) {
            return 0.75f;
        }
        if (this.last_x == 1.0f && this.last_y == -1.0f) {
            return 0.375f;
        }
        if (this.last_x == 1.0f && this.last_y == 0.0f) {
            return 0.5f;
        }
        if (this.last_x == 1.0f && this.last_y == 1.0f) {
            return 0.625f;
        }
        LinuxEnvironmentPlugin.logln(new StringBuffer().append("Unknown values x = ").append(this.last_x).append(" | y = ").append(this.last_y).toString());
        return 0.0f;
    }
}

