/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.PdhUtil$PdhEnumObjectItems;
import com.sun.jna.platform.win32.PdhUtil$PdhException;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinDef$DWORDByReference;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;

public abstract class PdhUtil {
    private static final int CHAR_TO_BYTES = Boolean.getBoolean("w32.ascii") ? 1 : Native.WCHAR_SIZE;
    private static final String ENGLISH_COUNTER_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009";
    private static final String ENGLISH_COUNTER_VALUE = "Counter";

    public static String PdhLookupPerfNameByIndex(String string, int n2) {
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD(0L));
        int n3 = Pdh.INSTANCE.PdhLookupPerfNameByIndex(string, n2, null, winDef$DWORDByReference);
        if (n3 != 0 && n3 != -2147481646) {
            throw new PdhUtil$PdhException(n3);
        }
        if (winDef$DWORDByReference.getValue().intValue() < 1) {
            return "";
        }
        Memory memory = new Memory(winDef$DWORDByReference.getValue().intValue() * CHAR_TO_BYTES);
        n3 = Pdh.INSTANCE.PdhLookupPerfNameByIndex(string, n2, memory, winDef$DWORDByReference);
        if (n3 != 0) {
            throw new PdhUtil$PdhException(n3);
        }
        if (CHAR_TO_BYTES == 1) {
            return memory.getString(0L);
        }
        return memory.getWideString(0L);
    }

    public static int PdhLookupPerfIndexByEnglishName(String string) {
        String[] stringArray = Advapi32Util.registryGetStringArray(WinReg.HKEY_LOCAL_MACHINE, ENGLISH_COUNTER_KEY, ENGLISH_COUNTER_VALUE);
        for (int i2 = 1; i2 < stringArray.length; i2 += 2) {
            if (!stringArray[i2].equals(string)) continue;
            try {
                return Integer.parseInt(stringArray[i2 - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public static PdhUtil$PdhEnumObjectItems PdhEnumObjectItems(String string, String string2, String string3, int n2) {
        String string4;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        WinDef$DWORDByReference winDef$DWORDByReference = new WinDef$DWORDByReference(new WinDef$DWORD(0L));
        WinDef$DWORDByReference winDef$DWORDByReference2 = new WinDef$DWORDByReference(new WinDef$DWORD(0L));
        int n4 = Pdh.INSTANCE.PdhEnumObjectItems(string, string2, string3, null, winDef$DWORDByReference, null, winDef$DWORDByReference2, n2, 0);
        if (n4 != 0 && n4 != -2147481646) {
            throw new PdhUtil$PdhException(n4);
        }
        Memory memory = null;
        Memory memory2 = null;
        if (winDef$DWORDByReference.getValue().intValue() > 0) {
            memory = new Memory(winDef$DWORDByReference.getValue().intValue() * CHAR_TO_BYTES);
        }
        if (winDef$DWORDByReference2.getValue().intValue() > 0) {
            memory2 = new Memory(winDef$DWORDByReference2.getValue().intValue() * CHAR_TO_BYTES);
        }
        if ((n4 = Pdh.INSTANCE.PdhEnumObjectItems(string, string2, string3, memory, winDef$DWORDByReference, memory2, winDef$DWORDByReference2, n2, 0)) != 0) {
            throw new PdhUtil$PdhException(n4);
        }
        if (memory != null) {
            n3 = 0;
            while ((long)n3 < memory.size()) {
                string4 = null;
                string4 = CHAR_TO_BYTES == 1 ? memory.getString(n3) : memory.getWideString(n3);
                if (string4.isEmpty()) break;
                arrayList.add(string4);
                n3 += (string4.length() + 1) * CHAR_TO_BYTES;
            }
        }
        if (memory2 != null) {
            n3 = 0;
            while ((long)n3 < memory2.size()) {
                string4 = null;
                string4 = CHAR_TO_BYTES == 1 ? memory2.getString(n3) : memory2.getWideString(n3);
                if (string4.isEmpty()) break;
                arrayList2.add(string4);
                n3 += (string4.length() + 1) * CHAR_TO_BYTES;
            }
        }
        return new PdhUtil$PdhEnumObjectItems(arrayList, arrayList2);
    }
}

