/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.ui.ogl.math;

import com.nttdocomo.ui.ogl.math.Point3f;
import com.nttdocomo.ui.ogl.math.Tuple4f;
import com.nttdocomo.ui.ogl.math.Vector3f;
import emulator.graphics3D.G3DUtils;

public final class Matrix4f {
    public float[] m = new float[16];
    private static final float[] a = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public Matrix4f() {
        this.setIdentity();
    }

    public Matrix4f(Matrix4f matrix4f) {
        System.arraycopy(matrix4f.m, 0, this.m, 0, 16);
    }

    public void mul(Matrix4f matrix4f) {
        float[] fArray = new float[16];
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                fArray[i3 * 4 + i2] = this.m[0 + i2] * matrix4f.m[i3 * 4 + 0] + this.m[4 + i2] * matrix4f.m[i3 * 4 + 1] + this.m[8 + i2] * matrix4f.m[i3 * 4 + 2] + this.m[12 + i2] * matrix4f.m[i3 * 4 + 3];
            }
        }
        this.m = fArray;
    }

    public void mul(Matrix4f matrix4f, Matrix4f matrix4f2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                this.m[i3 * 4 + i2] = matrix4f.m[0 + i2] * matrix4f2.m[i3 * 4 + 0] + matrix4f.m[4 + i2] * matrix4f2.m[i3 * 4 + 1] + matrix4f.m[8 + i2] * matrix4f2.m[i3 * 4 + 2] + matrix4f.m[12 + i2] * matrix4f2.m[i3 * 4 + 3];
            }
        }
    }

    public void transform(Tuple4f tuple4f) {
        float f2 = tuple4f.x;
        float f3 = tuple4f.y;
        float f4 = tuple4f.z;
        float f5 = tuple4f.w;
        tuple4f.x = this.m[0] * f2 + this.m[4] * f3 + this.m[8] * f4 + this.m[12] * f5;
        tuple4f.y = this.m[1] * f2 + this.m[5] * f3 + this.m[9] * f4 + this.m[13] * f5;
        tuple4f.z = this.m[2] * f2 + this.m[6] * f3 + this.m[10] * f4 + this.m[14] * f5;
        tuple4f.w = this.m[3] * f2 + this.m[7] * f3 + this.m[11] * f4 + this.m[15] * f5;
    }

    public void invert() {
        if (!G3DUtils.Invert4x4(this.m)) {
            throw new ArithmeticException();
        }
    }

    public void setIdentity() {
        System.arraycopy(a, 0, this.m, 0, 16);
    }

    public void translate(float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m[12] = f2;
        matrix4f.m[13] = f3;
        matrix4f.m[14] = f4;
        this.mul(matrix4f);
    }

    public void rotate(float f2, float f3, float f4, float f5) {
        float f6 = (float)Math.sqrt(f3 * f3 + f4 * f4 + f5 * f5);
        if (f6 != 0.0f) {
            f3 /= f6;
            f4 /= f6;
            f5 /= f6;
        }
        float f7 = (float)Math.cos(f2);
        float f8 = (float)Math.sin(f2);
        float f9 = 1.0f - f7;
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m[0] = f7 + f3 * f3 * f9;
        matrix4f.m[4] = f3 * f4 * f9 - f5 * f8;
        matrix4f.m[8] = f3 * f5 * f9 + f4 * f8;
        matrix4f.m[1] = f4 * f3 * f9 + f5 * f8;
        matrix4f.m[5] = f7 + f4 * f4 * f9;
        matrix4f.m[9] = f4 * f5 * f9 - f3 * f8;
        matrix4f.m[2] = f5 * f3 * f9 - f4 * f8;
        matrix4f.m[6] = f5 * f4 * f9 + f3 * f8;
        matrix4f.m[10] = f7 + f5 * f5 * f9;
        this.mul(matrix4f);
    }

    public void scale(float f2, float f3, float f4) {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m[0] = f2;
        matrix4f.m[5] = f3;
        matrix4f.m[10] = f4;
        this.mul(matrix4f);
    }

    public void lookAt(Point3f point3f, Point3f point3f2, Vector3f vector3f) {
        float f2 = point3f2.x - point3f.x;
        float f3 = point3f2.y - point3f.y;
        float f4 = point3f2.z - point3f.z;
        float f5 = 1.0f / (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        f2 *= f5;
        float f6 = 1.0f / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
        float f7 = vector3f.x * f6;
        float f8 = vector3f.y * f6;
        float f9 = vector3f.z * f6;
        float f10 = (f3 *= f5) * f9 - (f4 *= f5) * f8;
        float f11 = f4 * f7 - f2 * f9;
        float f12 = f2 * f8 - f3 * f7;
        float f13 = 1.0f / (float)Math.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        float f14 = (f11 *= f13) * f4 - (f12 *= f13) * f3;
        float f15 = f12 * f2 - (f10 *= f13) * f4;
        float f16 = f10 * f3 - f11 * f2;
        this.m[0] = f10;
        this.m[1] = f14;
        this.m[2] = -f2;
        this.m[3] = 0.0f;
        this.m[4] = f11;
        this.m[5] = f15;
        this.m[6] = -f3;
        this.m[7] = 0.0f;
        this.m[8] = f12;
        this.m[9] = f16;
        this.m[10] = -f4;
        this.m[11] = 0.0f;
        this.m[12] = -(f10 * point3f.x + f11 * point3f.y + f12 * point3f.z);
        this.m[13] = -(f14 * point3f.x + f15 * point3f.y + f16 * point3f.z);
        this.m[14] = f2 * point3f.x + f3 * point3f.y + f4 * point3f.z;
        this.m[15] = 1.0f;
    }
}

