/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.sound;

import com.nokia.mid.sound.SoundListener;
import com.nokia.mid.sound.a;
import emulator.Settings;
import java.io.ByteArrayInputStream;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerImpl;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.media.control.VolumeControlImpl;
import kemnn.aM;
import kemnn.aN;
import kemnn.aS;
import kemnn.aZ;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Sound {
    public static final int SOUND_PLAYING = 0;
    public static final int SOUND_STOPPED = 1;
    public static final int SOUND_UNINITIALIZED = 3;
    public static final int FORMAT_TONE = 1;
    public static final int FORMAT_WAV = 5;
    public Player m_player;
    private Sound a;
    private SoundListener a;
    private int a;
    private int b;
    public int dataLen;
    private static final short[] a = new short[]{0, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 29, 30, 32, 34, 36, 38, 41, 43, 45, 48, 51, 54, 57, 60, 64, 68, 72, 76, 81, 85, 90, 96, 101, 107, 114, 120, 128, 135, 143, 152, 161, 170, 180, 191, 202, 214, 227, 240, 255, 270, 286, 303, 321, 340, 360, 381, 404, 428, 453, 480, 509, 539, 571, 605, 641, 679, 719, 762, 807, 855, 906, 960, 1017, 1078, 1142, 1210, 1282, 1358, 1438, 1524, 1614, 1710, 1812, 1920, 2034, 2155, 2283, 2419, 2563, 2715, 2876, 3047, 3228, 3420, 3624, 3839, 4067, 4309, 4565, 4837, 5125, 5429, 5752, 6094, 6456, 6840, 7247, 7678, 8134, 8618, 9130, 9673, 10249, 10858, 11504, 12188, 12912};
    private final PlayerListener a;
    private byte[] a = new a(this);
    private int c = 255;

    public Sound(byte[] byArray, int n2) {
        this.b = n2;
        this.dataLen = byArray.length;
        this.a = this;
        this.init(byArray, n2);
    }

    public String getType() {
        if (this.b == 1) {
            return "FORMAT_TONE";
        }
        if (this.b == 5) {
            return "FORMAT_WAV";
        }
        return null;
    }

    public Sound(int n2, long l2) {
        this.init(n2, l2);
    }

    public static int getConcurrentSoundCount(int n2) {
        return 1;
    }

    public int getGain() {
        return ((VolumeControlImpl)this.m_player.getControl("VolumeControl")).getLevel();
    }

    public int getState() {
        return this.a;
    }

    public static int[] getSupportedFormats() {
        return new int[]{1, 5};
    }

    public void init(byte[] byArray, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 == 1) {
            switch (Settings.ottDecoder) {
                case 1: {
                    try {
                        byArray = new aN(byArray).a();
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                case 2: {
                    try {
                        byArray = aM.a(byArray);
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                default: {
                    this.m_player = new aS();
                    this.a = 3;
                    return;
                }
            }
        }
        if (Settings.enableMediaDump) {
            this.a = byArray;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.m_player = new PlayerImpl(byteArrayInputStream, this.b == 5 ? "audio/wav" : null);
            this.m_player.addPlayerListener(this.a);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a = 3;
    }

    public void init(int n2, long l2) {
        System.out.println("init " + n2 + " " + l2);
        if (l2 <= 0L) {
            throw new IllegalArgumentException("duration = " + l2);
        }
        if (n2 < 0 || n2 > a[a.length - 1]) {
            throw new IllegalArgumentException("freq = " + n2);
        }
        try {
            if (this.m_player != null) {
                this.m_player.close();
            }
            int n3 = Sound.convertFreqToNote(n2);
            this.m_player = aZ.a(n3, (int)l2, 100);
            if (this.m_player instanceof VolumeControl) {
                ((VolumeControl)((Object)this.m_player)).setLevel(this.c * 100 / 255);
            }
            this.a = 1;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            this.a = 3;
        }
    }

    public void play(int n2) {
        this.m_player.setLoopCount(n2 == 0 ? -1 : n2);
        this.resume();
    }

    public void release() {
        this.a = null;
        if (this.a == 0) {
            this.stop();
        }
        if (this.a != 3) {
            if (this.m_player != null) {
                this.m_player.deallocate();
            }
            this.a = 3;
            if (this.a != null) {
                this.a.soundStateChanged(this, 3);
            }
        }
    }

    public void resume() {
        try {
            this.m_player.start();
            if (this.b == 1) {
                ((MIDIControl)this.m_player.getControl("MIDIControl")).setChannelVolume(0, 64);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a = 0;
        if (this.a != null) {
            this.a.soundStateChanged(this, 0);
        }
    }

    public void setGain(int n2) {
        this.c = n2;
        ((VolumeControl)this.m_player.getControl("VolumeControl")).setLevel(this.c * 100 / 255);
    }

    public void setSoundListener(SoundListener soundListener) {
        this.a = soundListener;
    }

    public void stop() {
        try {
            this.m_player.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.a != 1) {
            this.a = 1;
            if (this.a != null) {
                this.a.soundStateChanged(this, 1);
            }
        }
    }

    public byte[] getData() {
        if (this.m_player == null || !(this.m_player instanceof PlayerImpl)) {
            return null;
        }
        if (this.a != null) {
            return (byte[])this.a.clone();
        }
        return ((PlayerImpl)this.m_player).getData();
    }

    public String getExportName() {
        switch (this.b) {
            case 1: {
                return "nokiatoneconverted" + this.hashCode() + ".mid";
            }
            case 5: {
                return "nokiaaudio" + this.hashCode() + ".wav";
            }
        }
        if (!(this.m_player instanceof PlayerImpl)) {
            return "unknown";
        }
        return "nokiaaudio" + ((PlayerImpl)this.m_player).getExportName();
    }

    protected void dispose() {
        try {
            if (this.m_player != null) {
                this.m_player.deallocate();
                this.m_player.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int convertFreqToNote(int n2) {
        int n3 = 0;
        int n4 = a.length - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            short s2 = a[n5];
            if (s2 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (s2 > n2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        if (n2 - a[n3 - 1] < a[n3] - n2) {
            return n3 - 1;
        }
        return n3;
    }

    static /* synthetic */ SoundListener a(Sound sound) {
        return sound.a;
    }
}

