/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDiscoveryEvent;
import com.github.sarxos.webcam.WebcamDiscoveryListener;
import com.github.sarxos.webcam.WebcamDiscoverySupport;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.d;
import com.github.sarxos.webcam.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamDiscoveryService
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WebcamDiscoveryService.class);
    private final WebcamDriver driver;
    private final WebcamDiscoverySupport support;
    private volatile List webcams = null;
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicBoolean enabled = new AtomicBoolean(true);
    private Thread runner = null;

    protected WebcamDiscoveryService(WebcamDriver webcamDriver) {
        if (webcamDriver == null) {
            throw new IllegalArgumentException("Driver cannot be null!");
        }
        this.driver = webcamDriver;
        this.support = (WebcamDiscoverySupport)((Object)(webcamDriver instanceof WebcamDiscoverySupport ? webcamDriver : null));
    }

    private static List toWebcams(List list2) {
        ArrayList<Webcam> arrayList = new ArrayList<Webcam>();
        for (WebcamDevice webcamDevice : list2) {
            arrayList.add(new Webcam(webcamDevice));
        }
        return arrayList;
    }

    private static List getDevices(List list2) {
        ArrayList<WebcamDevice> arrayList = new ArrayList<WebcamDevice>();
        for (Webcam webcam : list2) {
            arrayList.add(webcam.getDevice());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWebcams(long l2, TimeUnit timeUnit) throws TimeoutException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("Time unit cannot be null!");
        }
        ArrayList arrayList = null;
        WebcamDiscoveryListener[] webcamDiscoveryListenerArray = Webcam.class;
        synchronized (Webcam.class) {
            if (this.webcams == null) {
                e e2 = new e(this.driver);
                Object object = Executors.newSingleThreadExecutor(e2);
                Future future = object.submit(e2);
                object.shutdown();
                try {
                    object.awaitTermination(l2, timeUnit);
                    if (future.isDone()) {
                        this.webcams = (List)future.get();
                    } else {
                        future.cancel(true);
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                catch (ExecutionException executionException) {
                    throw new WebcamException(executionException);
                }
                if (this.webcams == null) {
                    throw new TimeoutException(String.format("Webcams discovery timeout (%d ms) has been exceeded", l2));
                }
                arrayList = new ArrayList(this.webcams);
                if (Webcam.isHandleTermSignal()) {
                    d.a(this.webcams.toArray(new Webcam[this.webcams.size()]));
                }
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (arrayList != null) {
                webcamDiscoveryListenerArray = Webcam.getDiscoveryListeners();
                for (Object object : arrayList) {
                    WebcamDiscoveryService.notifyWebcamFound((Webcam)object, webcamDiscoveryListenerArray);
                }
            }
            return Collections.unmodifiableList(this.webcams);
        }
    }

    public void scan() {
        WebcamDiscoveryListener[] webcamDiscoveryListenerArray = Webcam.getDiscoveryListeners();
        List list2 = this.driver.getDevices();
        List list3 = null;
        try {
            list3 = WebcamDiscoveryService.getDevices(this.getWebcams(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException timeoutException) {
            throw new WebcamException(timeoutException);
        }
        LinkedList linkedList = new LinkedList(list3);
        LinkedList linkedList2 = new LinkedList(list2);
        Iterator iterator = linkedList.iterator();
        Iterator iterator2 = null;
        WebcamDevice webcamDevice = null;
        WebcamDevice webcamDevice2 = null;
        block2: while (iterator.hasNext()) {
            webcamDevice = (WebcamDevice)iterator.next();
            iterator2 = linkedList2.iterator();
            while (iterator2.hasNext()) {
                webcamDevice2 = (WebcamDevice)iterator2.next();
                if (!webcamDevice2.getName().equals(webcamDevice.getName())) continue;
                iterator2.remove();
                iterator.remove();
                continue block2;
            }
        }
        if (linkedList.size() > 0) {
            ArrayList arrayList = new ArrayList();
            block4: for (Object object2 : linkedList) {
                for (Webcam webcam : this.webcams) {
                    if (!webcam.getDevice().getName().equals(object2.getName())) continue;
                    arrayList.add(webcam);
                    continue block4;
                }
            }
            this.setCurrentWebcams(list2);
            Object object = arrayList.iterator();
            while (object.hasNext()) {
                Object object2;
                object2 = (Webcam)object.next();
                WebcamDiscoveryService.notifyWebcamGone((Webcam)object2, webcamDiscoveryListenerArray);
                ((Webcam)object2).dispose();
            }
        }
        if (linkedList2.size() > 0) {
            this.setCurrentWebcams(list2);
            block7: for (Object object : linkedList2) {
                for (Object object3 : this.webcams) {
                    if (!((Webcam)object3).getDevice().getName().equals(object.getName())) continue;
                    WebcamDiscoveryService.notifyWebcamFound((Webcam)object3, webcamDiscoveryListenerArray);
                    continue block7;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.support == null) {
            return;
        }
        if (!this.support.isScanPossible()) {
            return;
        }
        Object object = new Object();
        do {
            Object object2 = object;
            synchronized (object2) {
                try {
                    object.wait(this.support.getScanInterval());
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Problem waiting on monitor", exception);
                }
            }
            this.scan();
        } while (this.running.get());
        LOG.debug("Webcam discovery service loop has been stopped");
    }

    private void setCurrentWebcams(List list2) {
        this.webcams = WebcamDiscoveryService.toWebcams(list2);
        if (Webcam.isHandleTermSignal()) {
            d.a();
            d.a(this.webcams.toArray(new Webcam[this.webcams.size()]));
        }
    }

    private static void notifyWebcamGone(Webcam webcam, WebcamDiscoveryListener[] webcamDiscoveryListenerArray) {
        WebcamDiscoveryEvent webcamDiscoveryEvent = new WebcamDiscoveryEvent(webcam, 2);
        for (WebcamDiscoveryListener webcamDiscoveryListener : webcamDiscoveryListenerArray) {
            try {
                webcamDiscoveryListener.webcamGone(webcamDiscoveryEvent);
            }
            catch (Exception exception) {
                LOG.error(String.format("Webcam gone, exception when calling listener %s", webcamDiscoveryListener.getClass()), exception);
            }
        }
    }

    private static void notifyWebcamFound(Webcam webcam, WebcamDiscoveryListener[] webcamDiscoveryListenerArray) {
        WebcamDiscoveryEvent webcamDiscoveryEvent = new WebcamDiscoveryEvent(webcam, 1);
        for (WebcamDiscoveryListener webcamDiscoveryListener : webcamDiscoveryListenerArray) {
            try {
                webcamDiscoveryListener.webcamFound(webcamDiscoveryEvent);
            }
            catch (Exception exception) {
                LOG.error(String.format("Webcam found, exception when calling listener %s", webcamDiscoveryListener.getClass()), exception);
            }
        }
    }

    public void start() {
        if (!this.enabled.get()) {
            LOG.info("Discovery service has been disabled and thus it will not be started");
            return;
        }
        if (this.support == null) {
            LOG.info("Discovery will not run - driver {} does not support this feature", this.driver.getClass().getSimpleName());
            return;
        }
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.runner = new Thread((Runnable)this, "webcam-discovery-service");
        this.runner.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
        this.runner.setDaemon(true);
        this.runner.start();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    static /* synthetic */ List access$000(List list2) {
        return WebcamDiscoveryService.toWebcams(list2);
    }
}

