/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.custom.ResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.InputConnection;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;

class Helpers {
    private static int[] pixels = null;

    static InputStream openInputStream(String s) throws IOException {
        try {
            String headerField;
            if (s.charAt(0) == '/') {
                return ResourceManager.getResourceAsStream((String)s);
            }
            InputConnection inputConnection = (InputConnection)Connector.open((String)s);
            if (inputConnection instanceof HttpConnection && (headerField = ((HttpConnection)inputConnection).getHeaderField("Content-Type")) != null && !headerField.equals("application/m3g") && !headerField.equals("image/png")) {
                throw new IOException("Wrong MIME type: " + headerField);
            }
            return inputConnection.openInputStream();
        }
        catch (MalformedURLException ex) {
            throw new IOException("Malformed URL: \"" + s + "\"");
        }
    }

    static int getTranslateX(Graphics graphics) {
        return graphics.getTranslateX();
    }

    static int getTranslateY(Graphics graphics) {
        return graphics.getTranslateY();
    }

    static int getClipX(Graphics graphics) {
        return graphics.getClipX();
    }

    static int getClipY(Graphics graphics) {
        return graphics.getClipY();
    }

    static int getClipWidth(Graphics graphics) {
        return graphics.getClipWidth();
    }

    static int getClipHeight(Graphics graphics) {
        return graphics.getClipHeight();
    }

    static void bindTarget(Graphics3D graphics3D, Graphics graphics, int n, int n2, int n3, int n4) {
        pixels = graphics.getImage().getData();
        Helpers.bindTarget(graphics3D, graphics.getImage().getWidth(), graphics.getImage().getHeight(), pixels, n, n2, n3, n4);
    }

    static void releaseTarget(Graphics3D graphics3D, Graphics graphics) {
        graphics.getImage().setData(pixels);
        pixels = null;
    }

    private static native void bindTarget(Graphics3D var0, int var1, int var2, int[] var3, int var4, int var5, int var6, int var7);

    static Image createImage(byte[] array, int n, int n2) throws IOException {
        return Image.createImage((byte[])array, (int)n, (int)n2);
    }

    static Image createImage(String s) throws IOException {
        return Image.createImage((String)s);
    }

    static int getImageWidth(Image image) {
        return image.getWidth();
    }

    static int getImageHeight(Image image) {
        return image.getHeight();
    }

    static boolean isOpaque(Image image) {
        return false;
    }

    static void getImageRGB(Image image, int[] array, int n, int n2, int n3, int n4, int n5, int n6) {
        image.getRGB(array, n, n2, n3, n4, n5, n6);
    }

    private Helpers() {
    }
}

