/*
 * Decompiled with CFR 0.152.
 */
package emulator.build;

import emulator.Emulator;
import emulator.Utils;
import emulator.ui.swt.devutils.ClasspathEntry;
import emulator.ui.swt.devutils.ClasspathEntryType;
import emulator.ui.swt.devutils.idea.ProjectConfigGenerator;
import emulator.ui.swt.devutils.idea.ProjectGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;

public class BuildSystem {
    private final Path projectRoot;
    private final String javac;
    private final String java;
    private final String jar;
    private Path manifestPath;
    private final String workingJarName;
    private final String projectName;
    private ClasspathEntry[] classpath;
    private final String proguardJar;
    private boolean deleteManifest = false;
    private final boolean obfuscate;
    private final boolean anyres;
    private final boolean runAfter;
    private final boolean skipMissing;
    public static final String OBF = "--obf";
    public static final String ANYRES = "--anyres";
    public static final String RUN = "--run";
    public static final String SKIPMISS = "--skipmiss";

    public BuildSystem(Path projectRoot, HashSet<String> args, Properties kemProps) {
        String jdkHome;
        this.projectRoot = projectRoot;
        this.obfuscate = args.contains(OBF);
        this.anyres = args.contains(ANYRES);
        this.runAfter = args.contains(RUN);
        this.skipMissing = args.contains(SKIPMISS);
        if (Utils.isJava9()) {
            System.out.println("Must be run with JDK 1.8.");
            System.exit(1);
        }
        if ((jdkHome = Utils.getJdkHome()) == null) {
            System.out.println("Must be run with JDK 1.8, not with JRE.");
            System.exit(1);
        }
        this.javac = Paths.get(jdkHome, "bin", Utils.win ? "javac.exe" : "javac").toString();
        this.java = Paths.get(jdkHome, "bin", Utils.win ? "java.exe" : "java").toString();
        this.jar = Paths.get(jdkHome, "bin", Utils.win ? "jar.exe" : "jar").toString();
        System.out.println("Building project at " + projectRoot);
        if (Files.exists(projectRoot.resolve("Application Descriptor"), new LinkOption[0])) {
            System.out.println("Found eclipse manifest, using...");
            this.manifestPath = projectRoot.resolve("Application Descriptor");
        } else if (Files.exists(projectRoot.resolve("META-INF/MANIFEST.MF"), new LinkOption[0])) {
            System.out.println("Found standard manifest, using...");
            this.manifestPath = projectRoot.resolve("META-INF/MANIFEST.MF");
        } else if (Files.exists(projectRoot.resolve("MANIFEST.MF"), new LinkOption[0])) {
            System.out.println("Found dangling manifest, using...");
            this.manifestPath = projectRoot.resolve("MANIFEST.MF");
        } else if (Files.exists(projectRoot.resolve("nbproject/project.properties"), new LinkOption[0])) {
            try {
                String manifest = ProjectGenerator.readManifestFromNetbeans(projectRoot.resolve("nbproject/project.properties"));
                this.manifestPath = Paths.get(Emulator.getUserPath(), new String[0]).resolve("NB_GENERATED_MANIFEST_" + System.currentTimeMillis() + ".MF");
                this.deleteManifest = true;
                System.out.println("Found NetBeans configuration. Manifest will be generated based on it.");
                Files.write(this.manifestPath, manifest.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                System.out.println("Failed to read NetBeans configuration. Exception: " + e);
                System.exit(1);
            }
        } else {
            System.out.println("No manifests found!");
            System.exit(1);
        }
        try {
            this.classpath = ClasspathEntry.readAnything(projectRoot);
        }
        catch (Exception e) {
            System.out.println("Failed to obtain classpath, see stacktrace:");
            e.printStackTrace();
            System.exit(1);
        }
        this.projectName = projectRoot.getFileName().toString();
        this.workingJarName = "." + File.separator + "deployed" + File.separator + "raw" + File.separator + this.projectName + ".jar";
        if (kemProps != null && kemProps.getProperty("ProguardPath", null) != null) {
            this.proguardJar = kemProps.getProperty("ProguardPath");
        } else if (Files.exists(Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("proguard.jar"), new LinkOption[0])) {
            this.proguardJar = Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("proguard.jar").toString();
        } else {
            System.out.println("Proguard jar is not in settings nor in local folder. Run Intellij IDEA setup and complete first step.");
            this.proguardJar = null;
            System.exit(1);
        }
    }

    public void build() {
        Path rawJar = this.projectRoot.resolve(this.workingJarName);
        try {
            Files.createDirectories(this.projectRoot.resolve("bin"), new FileAttribute[0]);
            Files.createDirectories(this.projectRoot.resolve("deployed").resolve("raw"), new FileAttribute[0]);
            for (File f2 : this.projectRoot.resolve("bin").toFile().listFiles()) {
                String[] stringArray;
                if (Utils.win) {
                    String[] stringArray2 = new String[4];
                    stringArray2[0] = "rd";
                    stringArray2[1] = "/s";
                    stringArray2[2] = "/q";
                    stringArray = stringArray2;
                    stringArray2[3] = f2.getAbsolutePath();
                } else {
                    String[] stringArray3 = new String[3];
                    stringArray3[0] = "rm";
                    stringArray3[1] = "-rf";
                    stringArray = stringArray3;
                    stringArray3[2] = f2.getAbsolutePath();
                }
                String[] args = stringArray;
                Runtime.getRuntime().exec(args).waitFor();
            }
            Files.deleteIfExists(rawJar);
        }
        catch (InterruptedException e2) {
            System.out.println("Cancelled.");
            System.exit(1);
        }
        catch (IOException e3) {
            System.out.println("Failed to prepare project state");
            System.exit(1);
        }
        System.out.println("Collecting sources...");
        ClasspathEntry[] javacArgs = new ArrayList();
        ArrayList sourceFiles = new ArrayList();
        Stream<Path> sourceClasspathStream = Arrays.stream(this.classpath).filter(ClasspathEntry::isJar).map(x -> x.getAbsolutePath(this.projectRoot));
        sourceClasspathStream = this.skipMissing ? sourceClasspathStream.filter(x$0 -> Files.exists(x$0, new LinkOption[0])) : sourceClasspathStream.peek(x -> {
            if (!Files.exists(x, new LinkOption[0])) {
                System.out.println("Library " + x + " does not exist. Pass " + SKIPMISS + " to ignore this.");
                System.exit(1);
            }
        });
        String builtClasspath = String.join((CharSequence)File.pathSeparator, (CharSequence[])sourceClasspathStream.map(Path::toString).toArray(String[]::new));
        String builtSourcepath = String.join((CharSequence)File.pathSeparator, (CharSequence[])Arrays.stream(this.classpath).filter(ClasspathEntry::isSourceCode).map(e -> {
            Path folder = e.getAbsolutePath(this.projectRoot);
            if (!Files.exists(folder, new LinkOption[0])) {
                System.out.println("Source folder " + folder + " does not exist. Pass " + SKIPMISS + " to ignore this.");
                System.exit(1);
            }
            if (Files.isSymbolicLink(folder)) {
                try {
                    folder = folder.getParent().resolve(Files.readSymbolicLink(folder)).normalize();
                }
                catch (IOException ex) {
                    System.out.println("Failed to read symbolic link: " + ex);
                    System.exit(1);
                }
            }
            try (Stream<Path> walk = Files.walk(folder, new FileVisitOption[0]);){
                walk.filter(x1 -> !Files.isDirectory(x1, new LinkOption[0]) && x1.getFileName().toString().endsWith(".java")).forEach(x1 -> sourceFiles.add(x1.toAbsolutePath().toString()));
            }
            catch (IOException ex) {
                System.out.println("Failed to list files in " + folder);
                System.out.println(ex);
                System.exit(1);
            }
            return folder.toString();
        }).toArray(String[]::new));
        javacArgs.add(this.javac);
        javacArgs.add("-Xlint:-options");
        javacArgs.add("-bootclasspath");
        javacArgs.add(BuildSystem.collectBootClassPath());
        javacArgs.add("-source");
        javacArgs.add("1.3");
        javacArgs.add("-target");
        javacArgs.add("1.3");
        javacArgs.add("-d");
        javacArgs.add("." + File.separator + "bin");
        if (!builtClasspath.isEmpty()) {
            javacArgs.add("-classpath");
            javacArgs.add(builtClasspath);
        }
        javacArgs.add("-sourcepath");
        javacArgs.add(builtSourcepath);
        javacArgs.addAll(sourceFiles);
        System.out.println("Running javac...");
        this.run("javac", new ProcessBuilder((List<String>)javacArgs), false);
        System.out.println("Packing classes");
        this.run("jar", new ProcessBuilder(this.jar, "cmf", this.manifestPath.toAbsolutePath().toString(), this.workingJarName, "-C", "bin", "."), true);
        for (ClasspathEntry entry : this.classpath) {
            if (entry.type == ClasspathEntryType.Resource) {
                Path abs = entry.getAbsolutePath(this.projectRoot);
                if (!Files.exists(abs, new LinkOption[0])) {
                    if (this.skipMissing) continue;
                    System.out.println("Resource folder " + abs + " does not exist. Pass " + SKIPMISS + " to ignore this.");
                    System.exit(1);
                }
                System.out.println("Packing resources from " + abs);
                this.run("jar", new ProcessBuilder(this.jar, "uf", this.workingJarName, "-C", abs.toString(), "."), true);
                continue;
            }
            if (!entry.isSourceCode() || !this.anyres) continue;
            Path folderT = entry.getAbsolutePath(this.projectRoot);
            System.out.println("Packing resources from " + folderT);
            ArrayList<String> jarArgs = new ArrayList<String>();
            jarArgs.add(this.jar);
            jarArgs.add("uf");
            jarArgs.add(this.workingJarName);
            if (Files.isSymbolicLink(folderT)) {
                try {
                    folderT = folderT.getParent().resolve(Files.readSymbolicLink(folderT)).normalize();
                }
                catch (IOException ex) {
                    System.out.println("Failed to read symbolic link: " + ex);
                    System.exit(1);
                }
            }
            Path folder = folderT;
            try (Stream<Path> walk = Files.walk(folder, new FileVisitOption[0]);){
                walk.filter(x1 -> !Files.isDirectory(x1, new LinkOption[0]) && !x1.getFileName().toString().endsWith(".java")).forEach(x1 -> {
                    String localPath = folder.relativize((Path)x1).toString();
                    jarArgs.add("-C");
                    if (entry.isLocalPath) {
                        jarArgs.add("." + File.separator + entry.path);
                    } else {
                        jarArgs.add(entry.getAbsolutePath(this.projectRoot).toString());
                    }
                    jarArgs.add(localPath);
                });
            }
            catch (IOException ex) {
                System.out.println("Failed to list files in " + entry.path);
                System.out.println(ex);
                System.exit(1);
            }
            if (jarArgs.size() <= 3) continue;
            this.run("jar", new ProcessBuilder(jarArgs), true);
        }
        try {
            String localConfig = ProjectConfigGenerator.buildLocalProguardConfig(this.projectRoot.toString(), this.projectName, this.classpath);
            if (!this.obfuscate) {
                localConfig = localConfig + "-dontoptimize -dontshrink -dontobfuscate" + System.lineSeparator() + "-keep class *" + System.lineSeparator();
            }
            Files.write(this.projectRoot.resolve("deployed").resolve("raw").resolve("build.cfg"), localConfig.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e4) {
            System.out.println("Failed to generate proguard config");
            e4.printStackTrace();
            System.exit(1);
        }
        ArrayList<String> proguardArgs = new ArrayList<String>();
        proguardArgs.add(this.java);
        proguardArgs.add("-jar");
        proguardArgs.add(this.proguardJar);
        proguardArgs.add("@deployed" + File.separator + "raw" + File.separator + "build.cfg");
        if (this.obfuscate && Files.exists(this.projectRoot.resolve("proguard.cfg"), new LinkOption[0])) {
            proguardArgs.add("@proguard.cfg");
        }
        this.run("proguard", new ProcessBuilder(proguardArgs), true);
        try {
            if (this.deleteManifest) {
                Files.deleteIfExists(this.manifestPath);
            }
            Files.deleteIfExists(this.projectRoot.resolve("deployed").resolve("raw").resolve("build.cfg"));
            Files.deleteIfExists(rawJar);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Build OK");
        if (this.runAfter) {
            System.out.println("Running built JAR...");
            this.run("kemulator", new ProcessBuilder(this.java, "-jar", Emulator.getAbsolutePath() + File.separator + "KUtils.jar", "-jar", this.projectRoot.resolve("deployed").resolve(this.projectName + ".jar").toString()), false);
        }
        System.exit(0);
    }

    private void run(String name, ProcessBuilder pb, boolean bufferOutput) {
        try {
            int code;
            StringBuilder sw = new StringBuilder();
            if (!bufferOutput) {
                pb.inheritIO();
            }
            Process proc = pb.directory(this.projectRoot.toFile()).start();
            if (bufferOutput) {
                try (InputStream is = proc.getInputStream();){
                    int c;
                    while ((c = is.read()) != -1) {
                        sw.append((char)c);
                    }
                }
                sw.append(System.lineSeparator());
                is = proc.getErrorStream();
                var7_10 = null;
                try {
                    while ((c = is.read()) != -1) {
                        sw.append((char)c);
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        if (var7_10 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {
                                var7_10.addSuppressed(throwable);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            if ((code = proc.waitFor()) != 0) {
                System.out.println(name + " exited with code " + code);
                if (bufferOutput) {
                    System.out.println("Log:");
                    System.out.println(sw);
                }
                System.exit(1);
            }
        }
        catch (InterruptedException e) {
            System.out.println("Cancelled.");
            System.exit(1);
        }
        catch (IOException e) {
            System.out.println("Failed to run " + name);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String collectBootClassPath() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (File f2 : Paths.get(Emulator.getAbsolutePath(), new String[0]).resolve("uei").toAbsolutePath().toFile().listFiles()) {
            if (!f2.getName().endsWith(".jar") || f2.getName().equals("emulator.jar")) continue;
            if (!first) {
                sb.append(File.pathSeparator);
            }
            first = false;
            sb.append(f2.getAbsolutePath());
        }
        return sb.toString();
    }
}

