/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    private static final String UTF8_STRING = "UTF8_STRING";
    private static final String STRING = "STRING";
    private static final int COMPOUND_TEXT_ID = TextTransfer.registerType("COMPOUND_TEXT");
    private static final int UTF8_STRING_ID = TextTransfer.registerType("UTF8_STRING");
    private static final int STRING_ID = TextTransfer.registerType("STRING");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (transferData.type == COMPOUND_TEXT_ID) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            boolean bl = OS.gdk_x11_display_utf8_to_compound_text(OS.gdk_display_get_default(), byArray, nArray, nArray2, nArray3, nArray4);
            if (!bl) {
                return;
            }
            transferData.type = nArray[0];
            transferData.format = nArray2[0];
            transferData.length = nArray4[0];
            transferData.pValue = nArray3[0];
            transferData.result = 1;
        }
        if (transferData.type == UTF8_STRING_ID) {
            int n = OS.g_malloc(byArray.length);
            if (n == 0) {
                return;
            }
            OS.memmove(n, byArray, byArray.length);
            transferData.type = UTF8_STRING_ID;
            transferData.format = 8;
            transferData.length = byArray.length - 1;
            transferData.pValue = n;
            transferData.result = 1;
        }
        if (transferData.type == STRING_ID) {
            int n = OS.gdk_utf8_to_string_target(byArray);
            if (n == 0) {
                return;
            }
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = OS.strlen(n);
            transferData.pValue = n;
            transferData.result = 1;
        }
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int n = OS.gdk_text_property_to_utf8_list_for_display(OS.gdk_display_get_default(), transferData.type, transferData.format, transferData.pValue, transferData.length, nArray);
        if (n == 0) {
            return null;
        }
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, nArray[0], OS.PTR_SIZEOF);
        int n2 = OS.strlen(nArray2[0]);
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, nArray2[0], n2);
        OS.g_strfreev(nArray[0]);
        char[] cArray = Converter.mbcsToWcs(byArray);
        String string = new String(cArray);
        int n3 = string.indexOf(0);
        return n3 == -1 ? string : string.substring(0, n3);
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{UTF8_STRING_ID, COMPOUND_TEXT_ID, STRING_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{UTF8_STRING, COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

