/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.ShortBufferImpl;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    ByteBufferImpl parent = null;
    short[] array;
    int arrayOffset;
    boolean isDirect;
    boolean disposed = false;

    ShortBuffer() {
    }

    public static ShortBuffer wrap(short[] array, int offset, int length) {
        if (offset < 0 || offset > array.length || length < 0 || length > array.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        ShortBufferImpl sbi = new ShortBufferImpl(null, array.length, array, 0, false);
        sbi.position(offset);
        sbi.limit(offset + length);
        return sbi;
    }

    public static ShortBuffer wrap(short[] array) {
        return ShortBuffer.wrap(array, 0, array.length);
    }

    public abstract ShortBuffer slice();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public ShortBuffer get(short[] dst, int offset, int length) {
        if (offset < 0 || offset > dst.length || length < 0 || length > dst.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.limit - this.position < length) {
            throw new BufferUnderflowException();
        }
        int bytePtr = this.arrayOffset + (this.position << 1);
        if (this.isDirect) {
            ByteBufferImpl._getShorts((int)bytePtr, (short[])dst, (int)offset, (int)length);
        } else if (this.array != null) {
            System.arraycopy(this.array, this.arrayOffset + this.position, dst, offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                dst[offset++] = this.parent.getShort(bytePtr);
                bytePtr += 2;
            }
        }
        this.position += length;
        return this;
    }

    public ShortBuffer get(short[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ShortBuffer put(ShortBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        ShortBufferImpl srci = (ShortBufferImpl)src;
        int length = srci.limit - srci.position;
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        if (this.isDirect && srci.isDirect) {
            ByteBufferImpl._copyBytes((int)(srci.arrayOffset + (srci.position << 1)), (int)(this.arrayOffset + (this.position << 1)), (int)(length << 1));
        } else if (this.isDirect && !srci.isDirect) {
            if (srci.array != null) {
                ByteBufferImpl._putShorts((int)(this.arrayOffset + (this.position << 1)), (short[])srci.array, (int)(srci.arrayOffset + srci.position), (int)length);
            } else {
                byte[] srcArray = srci.parent.array;
                int srciArrayOffset = srci.parent.arrayOffset + srci.arrayOffset + (srci.position << 1);
                ByteBufferImpl._putBytes((int)(this.arrayOffset + (this.position << 1)), (byte[])srcArray, (int)srciArrayOffset, (int)(2 * length));
            }
        } else if (!this.isDirect && srci.isDirect) {
            if (this.array != null) {
                ByteBufferImpl._getShorts((int)(srci.arrayOffset + (srci.position << 1)), (short[])this.array, (int)(this.arrayOffset + this.position), (int)length);
            } else {
                byte[] dstArray = this.parent.array;
                int dstArrayOffset = this.parent.arrayOffset + this.arrayOffset + (this.position << 1);
                ByteBufferImpl._getBytes((int)(srci.arrayOffset + (srci.position << 1)), (byte[])dstArray, (int)dstArrayOffset, (int)(2 * length));
            }
        } else if (!this.isDirect && !srci.isDirect) {
            if (this.array != null && srci.array != null) {
                System.arraycopy(srci.array, srci.arrayOffset + srci.position, this.array, this.arrayOffset + this.position, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    this.put(i + this.position, srci.get(i + srci.position));
                }
            }
        }
        srci.position += length;
        this.position += length;
        return this;
    }

    public ShortBuffer put(short[] src, int offset, int length) {
        if (offset < 0 || offset > src.length || length < 0 || length > src.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        int bytePtr = this.arrayOffset + (this.position << 1);
        if (this.isDirect) {
            ByteBufferImpl._putShorts((int)bytePtr, (short[])src, (int)offset, (int)length);
        } else if (this.array != null) {
            System.arraycopy(src, offset, this.array, this.arrayOffset + this.position, length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.parent.putShort(bytePtr, src[offset++]);
                bytePtr += 2;
            }
        }
        this.position += length;
        return this;
    }

    public final ShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.array != null;
    }

    public final short[] array() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.ShortBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer that = (ShortBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            short v2;
            short v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public int compareTo(Object ob) {
        ShortBuffer that = (ShortBuffer)ob;
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            short v2;
            short v1 = this.get(i);
            if (v1 != (v2 = that.get(j)) && (v1 == v1 || v2 == v2)) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }
}

