/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.StackWalkUtil;

class MemoryStack$DebugMemoryStack
extends MemoryStack {
    private Object[] debugFrames = new Object[8];

    MemoryStack$DebugMemoryStack(ByteBuffer byteBuffer, long l2, int n2) {
        super(byteBuffer, l2, n2);
    }

    @Override
    public MemoryStack push() {
        if (this.frameIndex == this.debugFrames.length) {
            this.frameOverflow();
        }
        this.debugFrames[this.frameIndex] = StackWalkUtil.stackWalkGetMethod(MemoryStack.class);
        return super.push();
    }

    private void frameOverflow() {
        this.debugFrames = Arrays.copyOf(this.debugFrames, this.debugFrames.length * 3 / 2);
    }

    @Override
    public MemoryStack pop() {
        Object object = this.debugFrames[this.frameIndex - 1];
        Object object2 = StackWalkUtil.stackWalkCheckPop(MemoryStack.class, object);
        if (object2 != null) {
            MemoryStack$DebugMemoryStack.reportAsymmetricPop(object, object2);
        }
        this.debugFrames[this.frameIndex - 1] = null;
        return super.pop();
    }

    @Override
    public void close() {
        this.debugFrames[this.frameIndex - 1] = null;
        super.pop();
    }

    private static void reportAsymmetricPop(Object object, Object object2) {
        APIUtil.DEBUG_STREAM.format("[LWJGL] Asymmetric pop detected:\n\tPUSHED: %s\n\tPOPPED: %s\n\tTHREAD: %s\n", object, object2, Thread.currentThread());
    }
}

