/*
 * Decompiled with CFR 0.152.
 */
package org.bridj.objc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bridj.BridJ;
import org.bridj.BridJRuntime$TypeInfo;
import org.bridj.CLong;
import org.bridj.CRuntime;
import org.bridj.CRuntime$MethodCallInfoBuilder;
import org.bridj.CallbackInterface;
import org.bridj.MethodCallInfo;
import org.bridj.NativeEntities$Builder;
import org.bridj.NativeLibrary;
import org.bridj.NativeObjectInterface;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.Pointer$Releaser;
import org.bridj.ann.Library;
import org.bridj.demangling.Demangler;
import org.bridj.objc.ObjCBlock;
import org.bridj.objc.ObjCClass;
import org.bridj.objc.ObjCObject;
import org.bridj.objc.ObjectiveCRuntime$1;
import org.bridj.objc.ObjectiveCRuntime$2;
import org.bridj.objc.SEL;
import org.bridj.objc.Selector;
import org.bridj.util.Utils;

public class ObjectiveCRuntime
extends CRuntime {
    Map nativeClassesByObjCName = new HashMap();
    Map nativeMetaClassesByObjCName = new HashMap();
    static final Map signatureByType = new HashMap();
    static final Map typesBySignature = new HashMap();
    Map bridjClassesByObjCName = new HashMap();
    static final Pointer$Releaser ObjCBlockReleaser;

    @Override
    public boolean isAvailable() {
        return Platform.isMacOSX();
    }

    public ObjectiveCRuntime() {
        BridJ.register();
        this.rootCallbackClasses.add(ObjCBlock.class);
    }

    ObjCObject realCast(Pointer pointer) {
        if (pointer == null) {
            return null;
        }
        Pointer pointer2 = ObjectiveCRuntime.object_getClassName(pointer);
        if (pointer2 == null) {
            throw new RuntimeException("Null class name for this ObjectiveC object pointer !");
        }
        String string = pointer2.getCString();
        Class clazz = (Class)this.bridjClassesByObjCName.get(string);
        if (clazz == null) {
            throw new RuntimeException("Class " + string + " was not registered yet in the BridJ runtime ! (TODO : auto create by scanning path, then reflection !)");
        }
        return (ObjCObject)pointer.getNativeObject(clazz);
    }

    protected static native Pointer object_getClass(Pointer var0);

    protected static native Pointer objc_getClass(Pointer var0);

    protected static native Pointer objc_getMetaClass(Pointer var0);

    protected static native Pointer object_getClassName(Pointer var0);

    protected static native Pointer class_createInstance(Pointer var0, long var1);

    public static native Pointer objc_getProtocol(Pointer var0);

    public static native boolean class_addProtocol(Pointer var0, Pointer var1);

    protected static native boolean class_respondsToSelector(Pointer var0, SEL var1);

    protected static native SEL sel_registerName(Pointer var0);

    protected static native Pointer sel_getName(SEL var0);

    public String getMethodSignature(Method method) {
        return this.getMethodSignature(method.getGenericReturnType(), method.getGenericParameterTypes());
    }

    public String getMethodSignature(Type type, Type ... typeArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTypeSignature(type));
        stringBuilder.append(this.getTypeSignature((Type)((Object)Pointer.class)));
        stringBuilder.append(this.getTypeSignature((Type)((Object)SEL.class)));
        for (Type type2 : typeArray) {
            stringBuilder.append(this.getTypeSignature(type2));
        }
        return stringBuilder.toString();
    }

    char getTypeSignature(Type type) {
        Character c2 = (Character)signatureByType.get(type);
        if (c2 == null) {
            c2 = (Character)signatureByType.get(Utils.getClass(type));
        }
        if (c2 == null) {
            throw new RuntimeException("Unknown type for Objective-C signatures : " + Utils.toString(type));
        }
        return c2.charValue();
    }

    static void addSignature(char c2, Type ... typeArray) {
        ArrayList<Type> arrayList = (ArrayList<Type>)typesBySignature.get(Character.valueOf(c2));
        if (arrayList == null) {
            arrayList = new ArrayList<Type>();
            typesBySignature.put(Character.valueOf(c2), arrayList);
        }
        for (Type type : typeArray) {
            signatureByType.put(type, Character.valueOf(c2));
            if (type == null || arrayList.contains(type)) continue;
            arrayList.add(type);
        }
    }

    static void initSignatures() {
        boolean bl2 = CLong.SIZE == 4;
        ObjectiveCRuntime.addSignature('q', new Type[]{Long.TYPE, !bl2 ? CLong.class : null});
        ObjectiveCRuntime.addSignature('i', new Type[]{Integer.TYPE, bl2 ? CLong.class : null});
        ObjectiveCRuntime.addSignature('I', new Type[]{Integer.TYPE, bl2 ? CLong.class : null});
        ObjectiveCRuntime.addSignature('s', Short.TYPE, Character.TYPE);
        ObjectiveCRuntime.addSignature('c', Byte.TYPE, Boolean.TYPE);
        ObjectiveCRuntime.addSignature('f', Float.TYPE);
        ObjectiveCRuntime.addSignature('d', Double.TYPE);
        ObjectiveCRuntime.addSignature('v', Void.TYPE);
        ObjectiveCRuntime.addSignature('@', new Type[]{Pointer.class});
        ObjectiveCRuntime.addSignature(':', new Type[]{SEL.class});
    }

    synchronized Pointer getObjCClass(String string, boolean bl2) throws ClassNotFoundException {
        if (string.equals("")) {
            return null;
        }
        Map map = bl2 ? this.nativeMetaClassesByObjCName : this.nativeClassesByObjCName;
        Pointer pointer = (Pointer)map.get(string);
        if (pointer == null) {
            Pointer pointer2 = Pointer.pointerToCString(string);
            Pointer pointer3 = pointer = bl2 ? ObjectiveCRuntime.objc_getMetaClass(pointer2) : ObjectiveCRuntime.objc_getClass(pointer2);
            if (pointer != null) {
                assert (ObjectiveCRuntime.object_getClassName(pointer).getCString().equals(string));
                map.put(string, pointer);
            }
        }
        if (pointer == null) {
            throw new ClassNotFoundException("Objective C class not found : " + string);
        }
        return pointer;
    }

    @Override
    protected NativeLibrary getNativeLibrary(Class clazz) throws IOException {
        Library library = clazz.getAnnotation(Library.class);
        if (library != null) {
            try {
                String string = library.value();
                return BridJ.getNativeLibrary(string, new File("/System/Library/Frameworks/" + string + ".framework/" + string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return super.getNativeLibrary(clazz);
    }

    @Override
    public void register(Type type) {
        Class clazz = Utils.getClass(type);
        clazz.getAnnotation(Library.class);
        Library library = clazz.getAnnotation(Library.class);
        if (library != null) {
            String string = library.value();
            File file = BridJ.getNativeLibraryFile(string);
            if (file != null) {
                System.load(file.toString());
            }
            if (ObjCObject.class.isAssignableFrom(clazz)) {
                this.bridjClassesByObjCName.put(clazz.getSimpleName(), clazz);
            }
        }
        super.register(type);
    }

    public String getSelector(Method method) {
        Selector selector = method.getAnnotation(Selector.class);
        if (selector != null) {
            return selector.value();
        }
        String string = Demangler.getMethodName(method);
        if (string.endsWith("_")) {
            string = string.substring(0, string.length() - 1);
        }
        if (method.getParameterTypes().length > 0) {
            string = string + ":";
        }
        string = string.replace('_', ':');
        return string;
    }

    @Override
    protected void registerNativeMethod(Class clazz, NativeLibrary nativeLibrary, Method method, NativeLibrary nativeLibrary2, NativeEntities$Builder nativeEntities$Builder, CRuntime$MethodCallInfoBuilder cRuntime$MethodCallInfoBuilder) throws FileNotFoundException {
        if (method == null) {
            return;
        }
        if (!ObjCObject.class.isAssignableFrom(clazz) || ObjCBlock.class.isAssignableFrom(clazz)) {
            super.registerNativeMethod(clazz, nativeLibrary, method, nativeLibrary2, nativeEntities$Builder, cRuntime$MethodCallInfoBuilder);
            return;
        }
        try {
            MethodCallInfo methodCallInfo = cRuntime$MethodCallInfoBuilder.apply(method);
            boolean bl2 = Modifier.isStatic(method.getModifiers());
            if (bl2) {
                Pointer pointer = this.getObjCClass(clazz).as(ObjCClass.class);
                ObjCClass objCClass = (ObjCClass)pointer.get();
                methodCallInfo.setNativeClass(pointer.getPeer());
            }
            methodCallInfo.setSymbolName(this.getSelector(method));
            nativeEntities$Builder.addObjCMethod(methodCallInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Failed to register method " + method + " : " + classNotFoundException, classNotFoundException);
        }
    }

    public static ObjectiveCRuntime getInstance() {
        return (ObjectiveCRuntime)BridJ.getRuntimeByRuntimeClass(ObjectiveCRuntime.class);
    }

    public static Type getBlockCallbackType(Class clazz) {
        if (!ObjCBlock.class.isAssignableFrom(clazz) || ObjCBlock.class == clazz) {
            throw new RuntimeException("Class " + clazz.getName() + " should be a subclass of " + ObjCBlock.class.getName());
        }
        Type type = clazz.getGenericSuperclass();
        if (Utils.getClass(type) == ObjCBlock.class) {
            Type type2 = Utils.getUniqueParameterizedTypeParameter(type);
            if (type2 == null || !(type2 instanceof Class) && !(type2 instanceof ParameterizedType)) {
                throw new RuntimeException("Class " + clazz.getName() + " should inherit from " + ObjCBlock.class.getName() + " with a valid single type parameter (found " + Utils.toString(type) + ")");
            }
            return type2;
        }
        throw new RuntimeException("Unexpected failure in getBlockCallbackType");
    }

    @Override
    public BridJRuntime$TypeInfo getTypeInfo(Type type) {
        return new ObjectiveCRuntime$2(this, type);
    }

    public static Pointer getObjCClass(String string) throws ClassNotFoundException {
        return ObjectiveCRuntime.getInstance().getObjCClass(string, false);
    }

    private Pointer getObjCClass(Class clazz) throws ClassNotFoundException {
        if (clazz == ObjCClass.class) {
            return this.getObjCClass("NSObject", true);
        }
        if (clazz == ObjCObject.class) {
            return this.getObjCClass("NSObject", false);
        }
        return this.getObjCClass(clazz.getSimpleName(), false);
    }

    static /* synthetic */ Pointer access$000(ObjectiveCRuntime objectiveCRuntime, CallbackInterface callbackInterface) {
        return objectiveCRuntime.registerCallbackInstance(callbackInterface);
    }

    static /* synthetic */ void access$100(ObjectiveCRuntime objectiveCRuntime, NativeObjectInterface nativeObjectInterface, Pointer pointer) {
        objectiveCRuntime.setNativeObjectPeer(nativeObjectInterface, pointer);
    }

    static /* synthetic */ void access$200(ObjectiveCRuntime objectiveCRuntime, NativeObjectInterface nativeObjectInterface, Pointer pointer) {
        objectiveCRuntime.setNativeObjectPeer(nativeObjectInterface, pointer);
    }

    static /* synthetic */ Pointer access$300(ObjectiveCRuntime objectiveCRuntime, Class clazz) throws ClassNotFoundException {
        return objectiveCRuntime.getObjCClass(clazz);
    }

    static /* synthetic */ void access$400(ObjectiveCRuntime objectiveCRuntime, NativeObjectInterface nativeObjectInterface, Pointer pointer) {
        objectiveCRuntime.setNativeObjectPeer(nativeObjectInterface, pointer);
    }

    static {
        ObjectiveCRuntime.initSignatures();
        ObjCBlockReleaser = new ObjectiveCRuntime$1();
    }
}

