/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;
import net.java.games.input.Component$Identifier;
import net.java.games.input.Controller;
import net.java.games.input.Controller$PortType;
import net.java.games.input.Controller$Type;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;

public abstract class AbstractController
implements Controller {
    static final int EVENT_QUEUE_DEPTH = 32;
    private static final Event event = new Event();
    private final String name;
    private final Component[] components;
    private final Controller[] children;
    private final Rumbler[] rumblers;
    private final Map id_to_components = new HashMap();
    private EventQueue event_queue = new EventQueue(32);

    protected AbstractController(String string, Component[] componentArray, Controller[] controllerArray, Rumbler[] rumblerArray) {
        this.name = string;
        this.components = componentArray;
        this.children = controllerArray;
        this.rumblers = rumblerArray;
        for (int i2 = componentArray.length - 1; i2 >= 0; --i2) {
            this.id_to_components.put(componentArray[i2].getIdentifier(), componentArray[i2]);
        }
    }

    @Override
    public final Controller[] getControllers() {
        return this.children;
    }

    @Override
    public final Component[] getComponents() {
        return this.components;
    }

    @Override
    public final Component getComponent(Component$Identifier component$Identifier) {
        return (Component)this.id_to_components.get(component$Identifier);
    }

    @Override
    public final Rumbler[] getRumblers() {
        return this.rumblers;
    }

    @Override
    public Controller$PortType getPortType() {
        return Controller$PortType.UNKNOWN;
    }

    @Override
    public int getPortNumber() {
        return 0;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Controller$Type getType() {
        return Controller$Type.UNKNOWN;
    }

    @Override
    public final void setEventQueueSize(int n2) {
        try {
            this.setDeviceEventQueueSize(n2);
            this.event_queue = new EventQueue(n2);
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln(new StringBuffer().append("Failed to create new event queue of size ").append(n2).append(": ").append(iOException).toString());
        }
    }

    protected void setDeviceEventQueueSize(int n2) throws IOException {
    }

    @Override
    public final EventQueue getEventQueue() {
        return this.event_queue;
    }

    protected abstract boolean getNextDeviceEvent(Event var1) throws IOException;

    protected void pollDevice() throws IOException {
    }

    @Override
    public synchronized boolean poll() {
        Component[] componentArray = this.getComponents();
        try {
            this.pollDevice();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                AbstractComponent abstractComponent = (AbstractComponent)componentArray[i2];
                if (abstractComponent.isRelative()) {
                    abstractComponent.setPollData(0.0f);
                    continue;
                }
                abstractComponent.resetHasPolled();
            }
            while (this.getNextDeviceEvent(event)) {
                AbstractComponent abstractComponent = (AbstractComponent)event.getComponent();
                float f2 = event.getValue();
                if (abstractComponent.isRelative()) {
                    if (f2 == 0.0f) continue;
                    abstractComponent.setPollData(abstractComponent.getPollData() + f2);
                } else {
                    if (f2 == abstractComponent.getEventValue()) continue;
                    abstractComponent.setEventValue(f2);
                }
                if (this.event_queue.isFull()) continue;
                this.event_queue.add(event);
            }
            return true;
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln(new StringBuffer().append("Failed to poll device: ").append(iOException.getMessage()).toString());
            return false;
        }
    }
}

