/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.AWTMouse$Axis;
import net.java.games.input.AWTMouse$Button;
import net.java.games.input.Component;
import net.java.games.input.Component$Identifier$Axis;
import net.java.games.input.Component$Identifier$Button;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Mouse;
import net.java.games.input.Rumbler;

final class AWTMouse
extends Mouse
implements AWTEventListener {
    private static final int EVENT_X = 1;
    private static final int EVENT_Y = 2;
    private static final int EVENT_BUTTON = 4;
    private final List awt_events = new ArrayList();
    private final List processed_awt_events = new ArrayList();
    private int event_state = 1;

    protected AWTMouse() {
        super("AWTMouse", AWTMouse.createComponents(), new Controller[0], new Rumbler[0]);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 131120L);
    }

    private static final Component[] createComponents() {
        return new Component[]{new AWTMouse$Axis(Component$Identifier$Axis.X), new AWTMouse$Axis(Component$Identifier$Axis.Y), new AWTMouse$Axis(Component$Identifier$Axis.Z), new AWTMouse$Button(Component$Identifier$Button.LEFT), new AWTMouse$Button(Component$Identifier$Button.MIDDLE), new AWTMouse$Button(Component$Identifier$Button.RIGHT)};
    }

    private final void processButtons(int n2, float f2) {
        AWTMouse$Button aWTMouse$Button = this.getButton(n2);
        if (aWTMouse$Button != null) {
            aWTMouse$Button.setValue(f2);
        }
    }

    private final AWTMouse$Button getButton(int n2) {
        switch (n2) {
            case 1: {
                return (AWTMouse$Button)this.getLeft();
            }
            case 2: {
                return (AWTMouse$Button)this.getMiddle();
            }
            case 3: {
                return (AWTMouse$Button)this.getRight();
            }
        }
        return null;
    }

    private final void processEvent(AWTEvent aWTEvent) throws IOException {
        if (aWTEvent instanceof MouseWheelEvent) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
            AWTMouse$Axis aWTMouse$Axis = (AWTMouse$Axis)this.getWheel();
            aWTMouse$Axis.setValue(aWTMouse$Axis.poll() + (float)mouseWheelEvent.getWheelRotation());
        } else if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            AWTMouse$Axis aWTMouse$Axis = (AWTMouse$Axis)this.getX();
            AWTMouse$Axis aWTMouse$Axis2 = (AWTMouse$Axis)this.getY();
            aWTMouse$Axis.setValue(mouseEvent.getX());
            aWTMouse$Axis2.setValue(mouseEvent.getY());
            switch (mouseEvent.getID()) {
                case 501: {
                    this.processButtons(mouseEvent.getButton(), 1.0f);
                    break;
                }
                case 502: {
                    this.processButtons(mouseEvent.getButton(), 0.0f);
                    break;
                }
            }
        }
    }

    @Override
    public final synchronized void pollDevice() throws IOException {
        AWTMouse$Axis aWTMouse$Axis = (AWTMouse$Axis)this.getWheel();
        aWTMouse$Axis.setValue(0.0f);
        for (int i2 = 0; i2 < this.awt_events.size(); ++i2) {
            AWTEvent aWTEvent = (AWTEvent)this.awt_events.get(i2);
            this.processEvent(aWTEvent);
            this.processed_awt_events.add(aWTEvent);
        }
        this.awt_events.clear();
    }

    @Override
    protected final synchronized boolean getNextDeviceEvent(Event event) throws IOException {
        block9: while (true) {
            long l2;
            MouseEvent mouseEvent;
            if (this.processed_awt_events.isEmpty()) {
                return false;
            }
            AWTEvent aWTEvent = (AWTEvent)this.processed_awt_events.get(0);
            if (aWTEvent instanceof MouseWheelEvent) {
                mouseEvent = (MouseWheelEvent)aWTEvent;
                l2 = mouseEvent.getWhen() * 1000000L;
                event.set(this.getWheel(), ((MouseWheelEvent)mouseEvent).getWheelRotation(), l2);
                this.processed_awt_events.remove(0);
                continue;
            }
            if (!(aWTEvent instanceof MouseEvent)) continue;
            mouseEvent = (MouseEvent)aWTEvent;
            l2 = mouseEvent.getWhen() * 1000000L;
            switch (this.event_state) {
                case 1: {
                    this.event_state = 2;
                    event.set(this.getX(), mouseEvent.getX(), l2);
                    return true;
                }
                case 2: {
                    this.event_state = 4;
                    event.set(this.getY(), mouseEvent.getY(), l2);
                    return true;
                }
                case 4: {
                    this.processed_awt_events.remove(0);
                    this.event_state = 1;
                    AWTMouse$Button aWTMouse$Button = this.getButton(mouseEvent.getButton());
                    if (aWTMouse$Button == null) continue block9;
                    switch (mouseEvent.getID()) {
                        case 501: {
                            event.set(aWTMouse$Button, 1.0f, l2);
                            return true;
                        }
                        case 502: {
                            event.set(aWTMouse$Button, 0.0f, l2);
                            return true;
                        }
                    }
                    continue block9;
                }
            }
            break;
        }
        throw new RuntimeException(new StringBuffer().append("Unknown event state: ").append(this.event_state).toString());
    }

    @Override
    public final synchronized void eventDispatched(AWTEvent aWTEvent) {
        this.awt_events.add(aWTEvent);
    }
}

