/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Sprite3D
extends Node {
    private boolean scaled;
    private Image2D image;
    private Appearance appearance;
    private int cropX;
    private int cropY;
    private int cropWidth;
    private int cropHeight;

    public Sprite3D(boolean bl2, Image2D image2D, Appearance appearance) {
        this.scaled = bl2;
        this.setImage(image2D);
        this.setAppearance(appearance);
    }

    public void setImage(Image2D image2D) {
        if (image2D == null) {
            throw new NullPointerException();
        }
        this.removeReference(this.image);
        this.image = image2D;
        this.addReference(this.image);
        this.cropY = 0;
        this.cropX = 0;
        this.cropWidth = Math.min(image2D.getWidth(), 1024);
        this.cropHeight = Math.min(image2D.getHeight(), 1024);
    }

    public Image2D getImage() {
        return this.image;
    }

    public boolean isScaled() {
        return this.scaled;
    }

    public void setAppearance(Appearance appearance) {
        this.removeReference(this.appearance);
        this.appearance = appearance;
        this.addReference(this.appearance);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setCrop(int n2, int n3, int n4, int n5) {
        if (Math.abs(n4) > 1024 || Math.abs(n5) > 1024) {
            throw new IllegalArgumentException("width or height exceeds the MaxSpriteCropDimension:1024");
        }
        this.cropX = n2;
        this.cropY = n3;
        this.cropWidth = n4;
        this.cropHeight = n5;
    }

    public int getCropX() {
        return this.cropX;
    }

    public int getCropY() {
        return this.cropY;
    }

    public int getCropWidth() {
        return this.cropWidth;
    }

    public int getCropHeight() {
        return this.cropHeight;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 259: {
                this.cropX = G3DUtils.round(fArray[0]);
                this.cropY = G3DUtils.round(fArray[1]);
                if (fArray.length <= 2) break;
                this.cropWidth = G3DUtils.limit(G3DUtils.round(fArray[2]), -1024, 1024);
                this.cropHeight = G3DUtils.limit(G3DUtils.round(fArray[3]), -1024, 1024);
                return;
            }
            default: {
                super.updateProperty(n2, fArray);
            }
        }
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        block18: {
            block19: {
                block20: {
                    block21: {
                        int n3;
                        int n4;
                        float[] fArray2;
                        float[] fArray3;
                        float f2;
                        block22: {
                            int n5;
                            int n6;
                            float f3;
                            float[] fArray4;
                            int n7;
                            int n8;
                            int[] nArray;
                            if ((n2 & this.getScope()) == 0) {
                                return false;
                            }
                            if (this.appearance == null || this.image == null || !this.scaled || this.cropWidth == 0 || this.cropHeight == 0) break block18;
                            Camera camera = rayIntersection.getCamera();
                            if (camera == null || this.image == null) break block19;
                            int[] nArray2 = new int[]{this.cropX, this.cropY, this.cropWidth, this.cropHeight};
                            boolean bl2 = nArray2[2] < 0;
                            boolean bl3 = nArray2[3] < 0;
                            nArray2[2] = Math.abs(nArray2[2]);
                            nArray2[3] = Math.abs(nArray2[3]);
                            int[] nArray3 = new int[4];
                            if (!G3DUtils.intersectRectangle(nArray2[0], nArray2[1], nArray2[2], nArray2[3], 0, 0, this.image.getWidth(), this.image.getHeight(), nArray3)) {
                                return false;
                            }
                            Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                            Vector4f vector4f2 = new Vector4f(0.5f, 0.0f, 0.0f, 1.0f);
                            Vector4f vector4f3 = new Vector4f(0.0f, 0.5f, 0.0f, 1.0f);
                            Transform transform2 = new Transform();
                            this.getTransformTo(camera, transform2);
                            transform2.getImpl_().transform(vector4f);
                            transform2.getImpl_().transform(vector4f2);
                            transform2.getImpl_().transform(vector4f3);
                            Vector4f vector4f4 = new Vector4f(vector4f);
                            vector4f.mul(1.0f / vector4f.w);
                            vector4f2.mul(1.0f / vector4f2.w);
                            vector4f3.mul(1.0f / vector4f3.w);
                            f2 = (vector4f.z - fArray[6]) / (fArray[7] - fArray[6]);
                            vector4f2.sub(vector4f);
                            vector4f3.sub(vector4f);
                            Vector4f vector4f5 = new Vector4f(vector4f2.length(), 0.0f, 0.0f, 0.0f);
                            Vector4f vector4f6 = new Vector4f(0.0f, vector4f3.length(), 0.0f, 0.0f);
                            vector4f5.add(vector4f4);
                            vector4f6.add(vector4f4);
                            camera.getProjection(transform2);
                            transform2.getImpl_().transform(vector4f4);
                            transform2.getImpl_().transform(vector4f5);
                            transform2.getImpl_().transform(vector4f6);
                            if (!(vector4f4.w > 0.0f) || !(-vector4f4.w < vector4f4.z) || !(vector4f4.z <= vector4f4.w)) break block20;
                            vector4f4.mul(1.0f / vector4f4.w);
                            vector4f5.mul(1.0f / vector4f5.w);
                            vector4f6.mul(1.0f / vector4f6.w);
                            vector4f5.sub(vector4f4);
                            vector4f6.sub(vector4f4);
                            vector4f5.x = vector4f5.length() / (float)nArray2[2];
                            vector4f6.y = vector4f6.length() / (float)nArray2[3];
                            vector4f4.x -= (float)(2 * nArray2[0] + nArray2[2] - 2 * nArray3[0] - nArray3[2]) * vector4f5.x;
                            vector4f4.y += (float)(2 * nArray2[1] + nArray2[3] - 2 * nArray3[1] - nArray3[3]) * vector4f6.y;
                            vector4f5.x *= (float)nArray3[2];
                            vector4f6.y *= (float)nArray3[3];
                            float[] fArray5 = new float[12];
                            int[] nArray4 = new int[8];
                            fArray5[0] = vector4f4.x - vector4f5.x;
                            fArray5[1] = vector4f4.y + vector4f6.y;
                            fArray5[2] = vector4f4.z;
                            fArray5[3] = fArray5[0];
                            fArray5[4] = vector4f4.y - vector4f6.y;
                            fArray5[5] = fArray5[2];
                            fArray5[6] = vector4f4.x + vector4f5.x;
                            fArray5[7] = fArray5[1];
                            fArray5[8] = fArray5[2];
                            fArray5[9] = fArray5[6];
                            fArray5[10] = fArray5[4];
                            fArray5[11] = fArray5[2];
                            if (!bl2) {
                                nArray4[0] = nArray3[0];
                                nArray4[2] = nArray3[0];
                                nArray4[4] = nArray3[0] + nArray3[2];
                                nArray = nArray4;
                                n8 = 6;
                                n7 = nArray3[0] + nArray3[2];
                            } else {
                                nArray4[0] = nArray3[0] + nArray3[2];
                                nArray4[2] = nArray3[0] + nArray3[2];
                                nArray4[4] = nArray3[0];
                                nArray = nArray4;
                                n8 = 6;
                                n7 = nArray3[0];
                            }
                            nArray[n8] = n7;
                            if (!bl3) {
                                nArray4[1] = nArray3[1];
                                nArray4[3] = nArray3[1] + nArray3[3];
                                nArray4[5] = nArray3[1];
                                nArray = nArray4;
                                n8 = 7;
                                n7 = nArray3[1] + nArray3[3];
                            } else {
                                nArray4[1] = nArray3[1] + nArray3[3];
                                nArray4[3] = nArray3[1];
                                nArray4[5] = nArray3[1] + nArray3[3];
                                nArray = nArray4;
                                n8 = 7;
                                n7 = nArray3[1];
                            }
                            nArray[n8] = n7;
                            float f4 = 2.0f * rayIntersection.getPickX() - 1.0f;
                            float f5 = 1.0f - 2.0f * rayIntersection.getPickY();
                            if (!(f4 >= fArray5[0]) || !(f4 <= fArray5[6]) || !(f5 <= fArray5[1]) || !(f5 >= fArray5[4])) break block21;
                            if (!rayIntersection.testDistance(f2)) {
                                return false;
                            }
                            f4 -= fArray5[0];
                            f5 = fArray5[1] - f5;
                            fArray3 = new float[]{0.0f};
                            fArray2 = new float[]{0.0f};
                            if (!bl2) {
                                fArray4 = fArray3;
                                n8 = 0;
                                f3 = (float)nArray4[0] + (float)(nArray4[4] - nArray4[0]) * f4 / (fArray5[6] - fArray5[0]);
                            } else {
                                fArray4 = fArray3;
                                n8 = 0;
                                f3 = (float)nArray4[0] - (float)(nArray4[0] - nArray4[4]) * f4 / (fArray5[6] - fArray5[0]);
                            }
                            fArray4[n8] = f3;
                            if (!bl3) {
                                fArray4 = fArray2;
                                n8 = 0;
                                f3 = (float)nArray4[1] + (float)(nArray4[3] - nArray4[1]) * f5 / (fArray5[1] - fArray5[4]);
                            } else {
                                fArray4 = fArray2;
                                n8 = 0;
                                f3 = (float)nArray4[1] - (float)(nArray4[1] - nArray4[3]) * f5 / (fArray5[1] - fArray5[4]);
                            }
                            fArray4[n8] = f3;
                            int n9 = G3DUtils.limit(G3DUtils.round(fArray3[0]), 0, this.image.getWidth() - 1);
                            int n10 = G3DUtils.limit(G3DUtils.round(fArray2[0]), 0, this.image.getWidth() - 1);
                            fArray3[0] = G3DUtils.limit(fArray3[0], 0.0f, (float)this.image.getWidth());
                            fArray2[0] = G3DUtils.limit(fArray2[0], 0.0f, (float)this.image.getHeight());
                            n4 = 0;
                            n3 = -1;
                            if (this.appearance.getCompositingMode() != null) {
                                n4 = (int)(this.appearance.getCompositingMode().getAlphaThreshold() * 256.0f);
                            }
                            byte[] byArray = this.image.getImageData();
                            switch (this.image.getFormat()) {
                                case 96: {
                                    n6 = n10 * this.image.getWidth() * 1 + n9 * 1;
                                    n5 = 0;
                                    break;
                                }
                                default: {
                                    break block22;
                                }
                                case 98: {
                                    n6 = n10 * this.image.getWidth() * 2 + n9 * 2;
                                    n5 = 1;
                                    break;
                                }
                                case 100: {
                                    n6 = n10 * this.image.getWidth() * 4 + n9 * 4;
                                    n5 = 3;
                                }
                            }
                            n3 = byArray[n6 + n5];
                        }
                        fArray3[0] = fArray3[0] / (float)this.image.getWidth();
                        fArray2[0] = fArray2[0] / (float)this.image.getHeight();
                        if ((n3 & 0xFF) >= n4) {
                            return rayIntersection.endPick(f2, fArray3, fArray2, 0, this, new float[]{0.0f, 0.0f, 1.0f});
                        }
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

