/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.m3g.BoneTransform;
import emulator.graphics3D.m3g.MeshMorph;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class SkinnedMesh
extends Mesh {
    Group skeleton;
    public Vector boneTransList;
    public int[] vtxBones;
    public int[] vtxWeights;

    public SkinnedMesh(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Group group) {
        super(vertexBuffer, indexBuffer, appearance);
        if (group == null) {
            throw new NullPointerException();
        }
        if (group instanceof World || group.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = group;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertexBuffer.getVertexCount() * 4];
        this.vtxWeights = new int[vertexBuffer.getVertexCount() * 4];
    }

    public SkinnedMesh(VertexBuffer vertexBuffer, IndexBuffer[] indexBufferArray, Appearance[] appearanceArray, Group group) {
        super(vertexBuffer, indexBufferArray, appearanceArray);
        if (group == null) {
            throw new NullPointerException();
        }
        if (group instanceof World || group.getParent() != null) {
            throw new IllegalArgumentException();
        }
        this.skeleton = group;
        this.skeleton.parent = this;
        this.addReference(this.skeleton);
        this.boneTransList = new Vector();
        this.vtxBones = new int[vertexBuffer.getVertexCount() * 4];
        this.vtxWeights = new int[vertexBuffer.getVertexCount() * 4];
    }

    public Group getSkeleton() {
        return this.skeleton;
    }

    @Override
    protected Object3D duplicateObject() {
        SkinnedMesh skinnedMesh = (SkinnedMesh)super.duplicateObject();
        Group group = (Group)skinnedMesh.getSkeleton().duplicateObject();
        skinnedMesh.removeReference(skinnedMesh.skeleton);
        skinnedMesh.addReference(group);
        skinnedMesh.skeleton = group;
        group.parent = skinnedMesh;
        Hashtable hashtable = new Hashtable();
        this.getOldToNewBonesMapping(hashtable, this.skeleton, group);
        skinnedMesh.boneTransList = new Vector();
        for (int i2 = 0; i2 < this.boneTransList.size(); ++i2) {
            BoneTransform boneTransform = (BoneTransform)this.boneTransList.elementAt(i2);
            BoneTransform boneTransform2 = new BoneTransform((Node)hashtable.get(boneTransform.bone), boneTransform.toBoneTrans);
            skinnedMesh.boneTransList.add(boneTransform2);
        }
        skinnedMesh.vtxBones = (int[])this.vtxBones.clone();
        skinnedMesh.vtxWeights = (int[])this.vtxWeights.clone();
        return skinnedMesh;
    }

    private void getOldToNewBonesMapping(Hashtable hashtable, Node node, Node node2) {
        hashtable.put(node, node2);
        if (node instanceof Group) {
            Group group = (Group)node;
            Group group2 = (Group)node2;
            for (int i2 = 0; i2 < group.getChildCount(); ++i2) {
                Node node3 = group.getChild(i2);
                Node node4 = group2.getChild(i2);
                this.getOldToNewBonesMapping(hashtable, node3, node4);
            }
        } else if (node instanceof SkinnedMesh) {
            Group group = ((SkinnedMesh)node).getSkeleton();
            Group group3 = ((SkinnedMesh)node2).getSkeleton();
            this.getOldToNewBonesMapping(hashtable, group, group3);
        }
    }

    public void addTransform(Node node, int n2, int n3, int n4) {
        int n5;
        if (node == null) {
            throw new NullPointerException();
        }
        if (node != this.skeleton && !node.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 + n4 > 65535) {
            throw new IndexOutOfBoundsException();
        }
        BoneTransform boneTransform = null;
        int n6 = -1;
        for (n5 = 0; n5 < this.boneTransList.size(); ++n5) {
            BoneTransform boneTransform2 = (BoneTransform)this.boneTransList.elementAt(n5);
            if (boneTransform2.bone != node) continue;
            boneTransform = boneTransform2;
            n6 = n5;
            break;
        }
        if (boneTransform == null) {
            Transform transform = new Transform();
            if (!this.getTransformTo(node, transform)) {
                throw new ArithmeticException();
            }
            boneTransform = new BoneTransform(node, transform);
            this.boneTransList.add(boneTransform);
            n6 = this.boneTransList.size() - 1;
        }
        n5 = 4;
        for (int i2 = n3; i2 < n3 + n4; ++i2) {
            int n7 = Integer.MAX_VALUE;
            int n8 = -1;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n9 = this.vtxWeights[i2 * n5 + i3];
                if (this.vtxBones[i2 * n5 + i3] == n6 + 1) {
                    n8 = i3;
                    break;
                }
                if (n9 > n7) continue;
                n7 = n9;
                n8 = i3;
                if (n9 == 0) break;
            }
            if (this.vtxBones[i2 * n5 + n8] == n6 + 1) {
                int n10 = i2 * n5 + n8;
                this.vtxWeights[n10] = this.vtxWeights[n10] + n2;
                continue;
            }
            if (n7 > n2) {
                n8 = -1;
            }
            if (n8 == -1) continue;
            this.vtxBones[i2 * n5 + n8] = n6 + 1;
            this.vtxWeights[i2 * n5 + n8] = n2;
        }
        node.setSkinnedMeshBone();
    }

    @Override
    protected void alignment(Node node) {
        super.alignment(node);
        this.skeleton.alignment(node);
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        MeshMorph.getInstance().getMorphedVertexBuffer(this);
        MeshMorph.getInstance().clearCache();
        return super.rayIntersect(n2, fArray, rayIntersection, transform, MeshMorph.getInstance().morphed) || this.skeleton.rayIntersect(n2, fArray, rayIntersection, transform);
    }

    public Vector getTransforms() {
        return this.boneTransList;
    }

    public int[] getVerticesBones() {
        return this.vtxBones;
    }

    public int[] getVerticesWeights() {
        return this.vtxWeights;
    }

    public void getBoneTransform(Node node, Transform transform) {
        if (node == null) {
            throw new NullPointerException("bone");
        }
        if (transform == null) {
            throw new NullPointerException("transform");
        }
        if (node != this.skeleton && !node.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < this.boneTransList.size(); ++i2) {
            BoneTransform boneTransform = (BoneTransform)this.boneTransList.elementAt(i2);
            if (boneTransform.bone != node) continue;
            transform.set(boneTransform.toBoneTrans);
            return;
        }
    }

    public int getBoneVertices(Node node, int[] nArray, float[] fArray) {
        int n2;
        if (node == null) {
            throw new NullPointerException("bone");
        }
        if (node != this.skeleton && !node.isDescendantOf(this.skeleton)) {
            throw new IllegalArgumentException();
        }
        int n3 = this.boneTransList.size();
        for (n2 = 0; n2 < n3 && ((BoneTransform)this.boneTransList.elementAt((int)n2)).bone != node; ++n2) {
        }
        if (n2 >= n3) {
            return 0;
        }
        int n4 = this.vertices.getVertexCount();
        int n5 = 0;
        int n6 = 4;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n7 = 0;
            int n8 = 0;
            for (int i3 = 0; i3 < 4; ++i3) {
                int n9 = this.vtxWeights[i2 * 4 + i3];
                if (this.vtxBones[i2 * 4 + i3] == n2 + 1) {
                    n7 = n9;
                }
                n8 += n9;
            }
            if (n7 <= 0) continue;
            if (nArray != null && fArray != null) {
                if (nArray.length <= n5 || fArray.length <= n5) {
                    throw new IllegalArgumentException();
                }
                nArray[n5] = i2;
                fArray[n5] = (float)n7 / (float)n8;
            }
            ++n5;
        }
        return n5;
    }
}

