/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import emulator.graphics3D.Quaternion;
import emulator.graphics3D.Vector4f;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.SkinnedMesh;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.Transformable;

public abstract class Node
extends Transformable {
    public static final int NONE = 144;
    public static final int ORIGIN = 145;
    public static final int X_AXIS = 146;
    public static final int Y_AXIS = 147;
    public static final int Z_AXIS = 148;
    Node parent = null;
    private boolean renderingEnable = true;
    private boolean pickingEnable = true;
    private float alphaFactor = 1.0f;
    private int scope = -1;
    private int yTarget = 144;
    private int zTarget = 144;
    private Node yRef = null;
    private Node zRef = null;
    private boolean boneFlag = false;
    protected Node m_duplicatedNode;

    Node() {
    }

    public void setRenderingEnable(boolean bl2) {
        this.renderingEnable = bl2;
    }

    public void setPickingEnable(boolean bl2) {
        this.pickingEnable = bl2;
    }

    public void setScope(int n2) {
        this.scope = n2;
    }

    public void setAlphaFactor(float f2) {
        if (!(f2 >= 0.0f) || !(f2 <= 1.0f)) {
            throw new IllegalArgumentException();
        }
        this.alphaFactor = f2;
    }

    public boolean isRenderingEnabled() {
        return this.renderingEnable;
    }

    public boolean isPickingEnabled() {
        return this.pickingEnable;
    }

    public int getScope() {
        return this.scope;
    }

    public float getAlphaFactor() {
        return this.alphaFactor;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean getTransformTo(Node node, Transform transform) {
        int n2;
        if (node == null || transform == null) {
            throw new NullPointerException();
        }
        Transform transform2 = new Transform();
        Transform transform3 = new Transform();
        Transform transform4 = new Transform();
        if (this.getRoot() != node.getRoot()) {
            return false;
        }
        Node node2 = this;
        Node node3 = node;
        int n3 = node.getDepth();
        for (n2 = this.getDepth(); n2 > n3; --n2) {
            node2.getCompositeTransform(transform2);
            transform3.preMultiply(transform2);
            node2 = node2.parent;
        }
        while (n3 > n2) {
            node3.getCompositeTransform(transform2);
            transform4.preMultiply(transform2);
            --n3;
            node3 = node3.parent;
        }
        while (node2 != node3) {
            node2.getCompositeTransform(transform2);
            transform3.preMultiply(transform2);
            node2 = node2.parent;
            node3.getCompositeTransform(transform2);
            transform4.preMultiply(transform2);
            node3 = node3.parent;
        }
        transform4.getImpl_().invert();
        transform4.postMultiply(transform3);
        transform.set(transform4);
        return true;
    }

    protected int getDepth() {
        Node node = this;
        int n2 = 0;
        while (node.parent != null) {
            node = node.parent;
            ++n2;
        }
        return n2;
    }

    protected boolean isParentOf(Node node) {
        Node node2 = node;
        while (true) {
            Node node3 = node2;
            if (node2 == null) {
                return false;
            }
            if (this.equals(node3)) {
                return true;
            }
            node2 = node3.getParent();
        }
    }

    protected boolean isDescendantOf(Node node) {
        Node node2 = this.parent;
        while (true) {
            Node node3 = node2;
            if (node2 == null) {
                return false;
            }
            if (node.equals(node3)) {
                return true;
            }
            node2 = node3.getParent();
        }
    }

    public final void align(Node node) {
        this.alignment(node);
    }

    protected void alignment(Node node) {
        if (node == null) {
            node = this;
        }
        this.computeAlignment(node, null, null, null, null);
    }

    protected void computeAlignment(Node node, Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3, Vector4f vector4f4) {
        Node node2 = this.getRoot();
        if (this.zRef != null && (this.zRef.isDescendantOf(this) || this.zRef.getRoot() != node2)) {
            throw new IllegalStateException();
        }
        if (this.yRef == null || !this.yRef.isDescendantOf(this) && this.yRef.getRoot() == node2) {
            Transform transform = new Transform();
            Transform transform2 = new Transform();
            Vector4f vector4f5 = new Vector4f();
            Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
            float[] fArray = new float[3];
            this.getTranslation(fArray);
            if (this.zTarget != 144) {
                if (this.zRef == null && node == this) {
                    throw new IllegalStateException();
                }
                (this.zRef == null ? node : this.zRef).getTransformTo(this.parent, transform);
                transform2.postTranslate(-fArray[0], -fArray[1], -fArray[2]);
                transform.preMultiply(transform2);
                Node.transformTarget(this.zTarget, transform, vector4f, vector4f2, vector4f3, vector4f4, vector4f5);
                vector4f5.w = 0.0f;
                quaternion.setRotation(Vector4f.Z_AXIS, vector4f5, null);
            }
            if (this.yTarget != 144) {
                if (this.yRef == null && node == this) {
                    throw new IllegalStateException();
                }
                (this.yRef == null ? node : this.yRef).getTransformTo(this.parent, transform);
                transform2.postTranslate(-fArray[0], -fArray[1], -fArray[2]);
                transform.preMultiply(transform2);
                if (this.zTarget != 144) {
                    transform2.setIdentity();
                    transform2.postRotateQuat(quaternion.x, quaternion.y, quaternion.z, -quaternion.w);
                    transform.preMultiply(transform2);
                }
                Node.transformTarget(this.yTarget, transform, vector4f, vector4f2, vector4f3, vector4f4, vector4f5);
                vector4f5.w = 0.0f;
                if (this.zTarget != 144) {
                    Quaternion quaternion2 = new Quaternion();
                    quaternion2.setRotation(Vector4f.Y_AXIS, vector4f5, Vector4f.Z_AXIS);
                    quaternion.mul(quaternion2);
                } else {
                    quaternion.setRotation(Vector4f.Y_AXIS, vector4f5, null);
                }
            }
            if (this.zTarget != 144 || this.yTarget != 144) {
                this.rotation.set(quaternion);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private static void transformTarget(int n2, Transform transform, Vector4f vector4f, Vector4f vector4f2, Vector4f vector4f3, Vector4f vector4f4, Vector4f vector4f5) {
        switch (n2) {
            case 145: {
                vector4f5.set(vector4f == null ? Vector4f.ORIGIN : vector4f);
                break;
            }
            case 146: {
                vector4f5.set(vector4f2 == null ? Vector4f.X_AXIS : vector4f2);
                break;
            }
            case 147: {
                vector4f5.set(vector4f3 == null ? Vector4f.Y_AXIS : vector4f3);
                break;
            }
            case 148: {
                vector4f5.set(vector4f4 == null ? Vector4f.Z_AXIS : vector4f4);
            }
        }
        transform.getImpl_().transform(vector4f5);
    }

    public void setAlignment(Node node, int n2, Node node2, int n3) {
        if (n2 < 144 || n2 > 148 || n3 < 144 || n3 > 148) {
            throw new IllegalArgumentException("yTarget or zTarget is not one of the symbolic constants");
        }
        if (node == node2 && n2 == n3 && n3 != 144) {
            throw new IllegalArgumentException("(zRef == yRef) &&  (zTarget == yTarget != NONE)");
        }
        if (node == this || node2 == this) {
            throw new IllegalArgumentException("zRef or yRef is this Node");
        }
        this.zTarget = n2;
        this.yTarget = n3;
        this.zRef = node;
        this.yRef = node2;
    }

    public int getAlignmentTarget(int n2) {
        if (n2 != 148 && n2 != 147) {
            throw new IllegalArgumentException("axis != Z_AXIS && axis != Y_AXIS");
        }
        return n2 == 148 ? this.zTarget : this.yTarget;
    }

    public Node getAlignmentReference(int n2) {
        if (n2 != 148 && n2 != 147) {
            throw new IllegalArgumentException("axis != Z_AXIS && axis != Y_AXIS");
        }
        return n2 == 148 ? this.zRef : this.yRef;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 256: {
                this.alphaFactor = G3DUtils.limit(fArray[0], 0.0f, 1.0f);
                return;
            }
            case 269: {
                this.pickingEnable = fArray[0] >= 0.5f;
                return;
            }
            case 276: {
                this.renderingEnable = fArray[0] >= 0.5f;
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }

    protected Node getRoot() {
        Node node = this;
        while (node.parent != null) {
            node = node.parent;
        }
        return node;
    }

    protected abstract boolean rayIntersect(int var1, float[] var2, RayIntersection var3, Transform var4);

    protected void enableBoneFlag() {
        this.boneFlag = true;
    }

    protected void setSkinnedMeshBone() {
        Node node = this;
        while (true) {
            Node node2 = node;
            if (node == null || node2 instanceof SkinnedMesh) {
                return;
            }
            node2.enableBoneFlag();
            node = node2.getParent();
        }
    }

    protected boolean isSkinnedMeshBone() {
        return this.boneFlag;
    }

    protected void updateAlignReferences() {
        Node node;
        if (this.zTarget != 144) {
            node = this.zRef.m_duplicatedNode;
            if (this.zRef != null && node != null && node.isDescendantOf(this.m_duplicatedNode.getRoot())) {
                this.m_duplicatedNode.zRef = node;
            }
        }
        if (this.yTarget != 144) {
            node = this.yRef.m_duplicatedNode;
            if (this.yRef != null && node != null && node.isDescendantOf(this.m_duplicatedNode.getRoot())) {
                this.m_duplicatedNode.yRef = node;
            }
        }
    }

    protected void clearAlignReferences() {
        this.m_duplicatedNode = null;
    }

    @Override
    protected Object3D duplicateObject() {
        Node node = (Node)super.duplicateObject();
        ((Node)super.duplicateObject()).parent = null;
        this.m_duplicatedNode = node;
        return node;
    }
}

