/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.graphics3D.G3DUtils;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.RayIntersection;
import javax.microedition.m3g.Transform;

public class Light
extends Node {
    public static final int AMBIENT = 128;
    public static final int DIRECTIONAL = 129;
    public static final int OMNI = 130;
    public static final int SPOT = 131;
    private int mode = 129;
    private int color = 0xFFFFFF;
    private float intensity = 1.0f;
    private float constantAttenuation = 1.0f;
    private float linearAttenuation = 0.0f;
    private float quadraticAttenuation = 0.0f;
    private float spotAngle = 45.0f;
    private float spotExponent = 0.0f;

    public void setMode(int n2) {
        if (n2 < 128 || n2 > 131) {
            throw new IllegalArgumentException();
        }
        this.mode = n2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setIntensity(float f2) {
        this.intensity = f2;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setColor(int n2) {
        this.color = n2;
    }

    public int getColor() {
        return this.color;
    }

    public void setSpotAngle(float f2) {
        if (!(f2 >= 0.0f) || !(f2 <= 90.0f)) {
            throw new IllegalArgumentException("angle is not in [0, 90]");
        }
        this.spotAngle = f2;
    }

    public float getSpotAngle() {
        return this.spotAngle;
    }

    public void setSpotExponent(float f2) {
        if (!(f2 >= 0.0f) || !(f2 <= 128.0f)) {
            throw new IllegalArgumentException("exponent is not in [0, 128]");
        }
        this.spotExponent = f2;
    }

    public float getSpotExponent() {
        return this.spotExponent;
    }

    public void setAttenuation(float f2, float f3, float f4) {
        if (f2 >= 0.0f && f3 >= 0.0f && f4 >= 0.0f) {
            if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
                throw new IllegalArgumentException("all of the parameter values are zero");
            }
        } else {
            throw new IllegalArgumentException("any of the parameter values are negative");
        }
        this.constantAttenuation = f2;
        this.linearAttenuation = f3;
        this.quadraticAttenuation = f4;
    }

    public float getConstantAttenuation() {
        return this.constantAttenuation;
    }

    public float getLinearAttenuation() {
        return this.linearAttenuation;
    }

    public float getQuadraticAttenuation() {
        return this.quadraticAttenuation;
    }

    @Override
    protected void updateProperty(int n2, float[] fArray) {
        switch (n2) {
            case 258: {
                this.color = G3DUtils.getIntColor(fArray);
                return;
            }
            case 265: {
                this.intensity = fArray[0];
                return;
            }
            case 273: {
                this.spotAngle = G3DUtils.limit(fArray[0], 0.0f, 90.0f);
                return;
            }
            case 274: {
                this.spotExponent = G3DUtils.limit(fArray[0], 0.0f, 128.0f);
                return;
            }
        }
        super.updateProperty(n2, fArray);
    }

    @Override
    protected boolean rayIntersect(int n2, float[] fArray, RayIntersection rayIntersection, Transform transform) {
        return false;
    }
}

