/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import javax.microedition.m3g.AnimationController;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Fog;
import javax.microedition.m3g.KeyframeSequence;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.MorphingMesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transformable;
import javax.microedition.m3g.VertexBuffer;

public class AnimationTrack
extends Object3D {
    public static final int ALPHA = 256;
    public static final int AMBIENT_COLOR = 257;
    public static final int COLOR = 258;
    public static final int CROP = 259;
    public static final int DENSITY = 260;
    public static final int DIFFUSE_COLOR = 261;
    public static final int EMISSIVE_COLOR = 262;
    public static final int FAR_DISTANCE = 263;
    public static final int FIELD_OF_VIEW = 264;
    public static final int INTENSITY = 265;
    public static final int MORPH_WEIGHTS = 266;
    public static final int NEAR_DISTANCE = 267;
    public static final int ORIENTATION = 268;
    public static final int PICKABILITY = 269;
    public static final int SCALE = 270;
    public static final int SHININESS = 271;
    public static final int SPECULAR_COLOR = 272;
    public static final int SPOT_ANGLE = 273;
    public static final int SPOT_EXPONENT = 274;
    public static final int TRANSLATION = 275;
    public static final int VISIBILITY = 276;
    private KeyframeSequence keyframeSequence;
    private AnimationController controller;
    private int targetProperty;

    public AnimationTrack(KeyframeSequence keyframeSequence, int n2) {
        if (keyframeSequence == null) {
            throw new NullPointerException();
        }
        if (!AnimationTrack.isValidPropertyId(n2)) {
            throw new IllegalArgumentException();
        }
        if (!AnimationTrack.isValidComponentCount(n2, keyframeSequence.getComponentCount())) {
            throw new IllegalArgumentException();
        }
        this.keyframeSequence = keyframeSequence;
        this.targetProperty = n2;
        this.controller = null;
        this.addReference(this.keyframeSequence);
    }

    protected boolean checkCompatible(Object3D object3D) {
        switch (this.targetProperty) {
            case 256: {
                return object3D instanceof Node || object3D instanceof Background || object3D instanceof Material || object3D instanceof VertexBuffer;
            }
            case 257: {
                return object3D instanceof Material;
            }
            case 258: {
                return object3D instanceof Light || object3D instanceof Background || object3D instanceof Fog || object3D instanceof Texture2D || object3D instanceof VertexBuffer;
            }
            case 259: {
                return object3D instanceof Sprite3D || object3D instanceof Background;
            }
            case 260: {
                return object3D instanceof Fog;
            }
            case 261: {
                return object3D instanceof Material;
            }
            case 262: {
                return object3D instanceof Material;
            }
            case 263: {
                return object3D instanceof Camera || object3D instanceof Fog;
            }
            case 264: {
                return object3D instanceof Camera;
            }
            case 265: {
                return object3D instanceof Light;
            }
            case 266: {
                return object3D instanceof MorphingMesh;
            }
            case 267: {
                return object3D instanceof Camera || object3D instanceof Fog;
            }
            case 268: {
                return object3D instanceof Transformable;
            }
            case 269: {
                return object3D instanceof Node;
            }
            case 270: {
                return object3D instanceof Transformable;
            }
            case 271: {
                return object3D instanceof Material;
            }
            case 272: {
                return object3D instanceof Material;
            }
            case 273: {
                return object3D instanceof Light;
            }
            case 274: {
                return object3D instanceof Light;
            }
            case 275: {
                return object3D instanceof Transformable;
            }
            case 276: {
                return object3D instanceof Node;
            }
        }
        return false;
    }

    private static boolean isValidPropertyId(int n2) {
        return n2 >= 256 && n2 <= 276;
    }

    private static boolean isValidComponentCount(int n2, int n3) {
        switch (n2) {
            case 256: {
                return n3 == 1;
            }
            case 257: {
                return n3 == 3;
            }
            case 258: {
                return n3 == 3;
            }
            case 259: {
                return n3 == 2 || n3 == 4;
            }
            case 260: {
                return n3 == 1;
            }
            case 261: {
                return n3 == 3;
            }
            case 262: {
                return n3 == 3;
            }
            case 263: {
                return n3 == 1;
            }
            case 264: {
                return n3 == 1;
            }
            case 265: {
                return n3 == 1;
            }
            case 266: {
                return true;
            }
            case 267: {
                return n3 == 1;
            }
            case 268: {
                return n3 == 4;
            }
            case 269: {
                return n3 == 1;
            }
            case 270: {
                return n3 == 1 || n3 == 3;
            }
            case 271: {
                return n3 == 1;
            }
            case 272: {
                return n3 == 3;
            }
            case 273: {
                return n3 == 1;
            }
            case 274: {
                return n3 == 1;
            }
            case 275: {
                return n3 == 3;
            }
            case 276: {
                return n3 == 1;
            }
        }
        return false;
    }

    public void setController(AnimationController animationController) {
        this.removeReference(this.controller);
        this.controller = animationController;
        this.addReference(animationController);
    }

    public AnimationController getController() {
        return this.controller;
    }

    public KeyframeSequence getKeyframeSequence() {
        return this.keyframeSequence;
    }

    public int getTargetProperty() {
        return this.targetProperty;
    }

    protected void getContribution(int n2, float[] fArray, float[] fArray2) {
        if (this.controller != null && this.controller.isActive(n2)) {
            float[] fArray3 = new float[this.keyframeSequence.getComponentCount()];
            float f2 = this.controller.getPosition(n2);
            int n3 = this.keyframeSequence.getSampleFrame(f2, fArray3);
            float f3 = this.controller.getWeight();
            for (int i2 = 0; i2 < fArray3.length; ++i2) {
                int n4 = i2;
                fArray[n4] = fArray[n4] + fArray3[i2] * f3;
            }
            fArray2[0] = f3;
            fArray2[1] = Math.min(n3, this.controller.timeToDeactivation(n2));
        } else {
            fArray2[0] = 0.0f;
            fArray2[1] = Math.max(1, this.controller == null ? Integer.MAX_VALUE : this.controller.timeToActivation(n2));
        }
    }
}

