/*
 * Decompiled with CFR 0.152.
 */
package emulator;

import com.nttdocomo.ui.maker.IApplicationMIDlet;
import emulator.AppSettings;
import emulator.Settings;
import emulator.Utils;
import emulator.a;
import emulator.c;
import emulator.custom.CustomMethod;
import emulator.custom.ResourceManager;
import emulator.custom.b;
import emulator.d;
import emulator.f;
import emulator.graphics3D.IGraphics3D;
import emulator.k;
import emulator.n;
import emulator.o;
import emulator.s;
import emulator.ui.IEmulatorFrontend;
import emulator.ui.RichPresence;
import emulator.ui.swt.devutils.idea.j;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kemnn.aF;
import kemnn.aw;
import kemnn.bD;
import kemnn.cA;
import kemnn.eO;
import kemnn.eP;
import kemnn.em;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Emulator
implements Runnable {
    public static boolean debugBuild;
    public static String version;
    public static String revision;
    public static final int numericVersion = 34;
    private static IEmulatorFrontend a;
    private static MIDlet a;
    private static Canvas a;
    private static Screen a;
    private static f a;
    private static o a;
    public static Vector jarLibrarys;
    public static Vector jarClasses;
    public static String midletJar;
    public static String midletClassName;
    public static String classPath;
    public static String jadPath;
    public static String[] commandLineArguments;
    public static b customClassLoader;
    public static String iconPath;
    public static String httpUserAgent;
    private static final Thread a;
    public static k platform;
    public static final boolean isPortable;
    private static Class a;
    private static boolean a;
    private static boolean b;
    private static boolean c;
    public static boolean doja;
    static int a;
    static int b;

    private Emulator() {
    }

    public static IEmulatorFrontend getEmulator() {
        return a;
    }

    public static o getRobot() {
        return a;
    }

    public static Canvas getCanvas() {
        return a;
    }

    public static void setCanvas(Canvas canvas) {
        a = canvas;
        a.getScreen().setCurrent(canvas);
    }

    public static Screen getScreen() {
        return a;
    }

    public static void setScreen(Screen screen) {
        a = screen;
        a.getScreen().setCurrent(screen);
    }

    public static MIDlet getMIDlet() {
        return a;
    }

    public static void setMIDlet(MIDlet mIDlet) {
        a = mIDlet;
    }

    public static Display getCurrentDisplay() {
        return Display.getDisplay(a);
    }

    public static f getEventQueue() {
        return a;
    }

    public static b getCustomClassLoader() {
        return customClassLoader;
    }

    public static void notifyDestroyed() {
        RichPresence.close();
        aF.a();
        a.getProperty().saveProperties();
        if (Settings.autoGenJad) {
            Emulator.a();
        }
        AppSettings.save();
    }

    public static void openFileExternally(String string) {
        try {
            if (Utils.win) {
                Desktop.getDesktop().open(new File(string));
                return;
            }
            if (Utils.macos) {
                Runtime.getRuntime().exec("open \"" + string + "\"");
                return;
            }
            if (Utils.linux) {
                if (Files.isExecutable(Paths.get("/usr/bin/xdg-open", new String[0]))) {
                    Runtime.getRuntime().exec("/usr/bin/xdg-open \"" + string + "\"");
                } else if (Files.isExecutable(Paths.get("/usr/bin/gedit", new String[0]))) {
                    Runtime.getRuntime().exec("/usr/bin/gedit \"" + string + "\"");
                } else {
                    Emulator.getEmulator().getScreen().showMessage("Non XDG compliant systems are not supported.");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Emulator.getEmulator().getScreen().showMessage("Failed to open file.");
    }

    public static void openUrlExternally(String string) throws ConnectionNotFoundException {
        if (Utils.linux && Files.isExecutable(Paths.get("/usr/bin/xdg-open", new String[0]))) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/xdg-open", string});
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (Utils.macos) {
            try {
                Runtime.getRuntime().exec("open \"" + string + "\"");
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(string));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Utils.win) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ConnectionNotFoundException("not supported");
    }

    public static void openUrlExternallySilent(String string) {
        try {
            Emulator.openUrlExternally(string);
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            Emulator.getEmulator().getScreen().showMessage("Failed to open URL.");
        }
    }

    private static void a() {
        if (midletJar == null) {
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(midletJar.substring(0, midletJar.length() - 3) + "jad"), "UTF-8");
            Enumeration<Object> enumeration = a.getAppProperties().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equalsIgnoreCase("KEmu-Platform")) continue;
                outputStreamWriter.write(string + ": " + a.getAppProperties().getProperty(string) + "\r\n");
            }
            if (a.getAppProperties().getProperty("MIDlet-Jar-URL") == null) {
                outputStreamWriter.write("MIDlet-Jar-URL: " + new File(midletJar).getName() + "\r\n");
            }
            if (a.getAppProperties().getProperty("MIDlet-Jar-Size") == null) {
                outputStreamWriter.write("MIDlet-Jar-Size: " + new File(midletJar).length() + "\r\n");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getTitle(String string) {
        if (AppSettings.customTitle != null) {
            return AppSettings.customTitle;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(platform.b()).append(' ').append(version);
        if (string != null) {
            stringBuilder.append(" - ").append(string);
        } else if (midletJar != null && a.getAppProperties() != null) {
            stringBuilder.append(" - ").append(a.getAppProperty(doja ? "AppName" : "MIDlet-Name"));
        }
        if (AppSettings.uei) {
            stringBuilder.append(" (UEI)");
        }
        return stringBuilder.toString();
    }

    public static String getCmdVersionString() {
        return platform.a() + " " + version;
    }

    public static String getInfoString() {
        return platform.a((version.startsWith("2.") ? "v" : "") + version);
    }

    public static String getAboutString() {
        return "KEmulator nnmod\n" + version;
    }

    public static void getLibraries() {
        File file = new File(Emulator.getAbsolutePath(), "libs");
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string = fileArray[i2].getAbsolutePath();
                if (!string.endsWith(".jar")) continue;
                jarLibrarys.add(string);
            }
        }
    }

    public static String getJadPath() {
        File file;
        if (jadPath != null) {
            file = new File(jadPath);
        } else if (midletJar != null) {
            file = new File(midletJar.substring(0, midletJar.length() - 3) + "jad");
        } else {
            return null;
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getJarClasses() throws Exception {
        block36: {
            try {
                File file;
                if (midletClassName == null || midletJar != null) {
                    Object object2;
                    Object object3;
                    Vector<Object> vector2;
                    Properties properties;
                    block35: {
                        Object object4;
                        File file2;
                        properties = new Properties();
                        if (jadPath != null) {
                            file2 = new File(jadPath);
                        } else {
                            object4 = new StringBuffer();
                            file2 = new File(((StringBuffer)object4).append(midletJar, 0, midletJar.length() - 3).append("jad").toString());
                            if (!file2.exists()) {
                                ((StringBuffer)object4).setCharAt(((StringBuffer)object4).length() - 1, 'm');
                                file2 = new File(((StringBuffer)object4).toString());
                            }
                        }
                        if (file2.exists()) {
                            doja = file2.getName().endsWith(".jam");
                            properties.load(new InputStreamReader((InputStream)new FileInputStream(file2), doja ? "Shift_JIS" : "UTF-8"));
                            object4 = properties.keys();
                            while (object4.hasMoreElements()) {
                                vector2 = (String)object4.nextElement();
                                properties.put(vector2, properties.getProperty((String)((Object)vector2)));
                            }
                        }
                        if (doja) {
                            a.getLogStream().println("Running DoJa");
                            System.out.println(properties);
                            if (midletJar == null) {
                                object4 = file2.getName();
                                midletJar = ((String)object4).substring(0, ((String)object4).length() - 1) + 'r';
                            }
                        }
                        a.getLogStream().println("Get classes from " + midletJar);
                        object4 = new ZipFile(midletJar);
                        try {
                            vector2 = ((ZipFile)object4).getEntries();
                            while (vector2.hasMoreElements()) {
                                object3 = (ZipEntry)vector2.nextElement();
                                if (!((ZipEntry)object3).getName().endsWith(".class")) continue;
                                object2 = ((ZipEntry)object3).getName().substring(0, ((ZipEntry)object3).getName().length() - 6).replace('/', '.');
                                jarClasses.add(object2);
                                a.getLogStream().println("Get class " + (String)object2);
                            }
                            if (properties != null && properties.containsKey(doja ? "AppClass" : "MIDlet-1")) break block35;
                            try {
                                object3 = ((ZipFile)object4).getManifest().getMainAttributes();
                                for (Map.Entry object5 : ((Attributes)object3).entrySet()) {
                                    properties.put(object5.getKey().toString(), object5.getValue());
                                }
                                if (!properties.containsKey(doja ? "AppClass" : "MIDlet-1")) {
                                    throw new Exception();
                                }
                            }
                            catch (Exception exception) {
                                object2 = ((ZipFile)object4).getInputStream(((ZipFile)object4).getEntry("META-INF/MANIFEST.MF"));
                                ((InputStream)object2).skip(3L);
                                properties.load(new InputStreamReader((InputStream)object2, "UTF-8"));
                                ((InputStream)object2).close();
                                Enumeration<Object> enumeration = properties.keys();
                                while (enumeration.hasMoreElements()) {
                                    String string = (String)enumeration.nextElement();
                                    properties.put(string, properties.getProperty(string));
                                }
                            }
                        }
                        finally {
                            ((ZipFile)object4).close();
                        }
                    }
                    if (midletClassName != null) {
                        return true;
                    }
                    a.setAppProperties(properties);
                    if (properties.containsKey("MIDlet-2") && properties.containsKey("MIDlet-1")) {
                        vector2 = new Vector<Object>();
                        object3 = properties.keys();
                        while (object3.hasMoreElements()) {
                            object2 = (String)object3.nextElement();
                            if (!((String)object2).startsWith("MIDlet-")) continue;
                            String string = ((String)object2).substring("MIDlet-".length());
                            try {
                                Integer.parseInt(string);
                                vector2.add(object2);
                            }
                            catch (Exception exception) {}
                        }
                        if (vector2.size() != 0) {
                            int n2 = a.getScreen().showMidletChoice(vector2);
                            if (n2 == -1) {
                                CustomMethod.close();
                                System.exit(0);
                                return false;
                            }
                            String string = properties.getProperty((String)vector2.get(n2));
                            midletClassName = string.substring(string.lastIndexOf(",") + 1).trim();
                            return true;
                        }
                    }
                    if (doja) {
                        midletClassName = properties.getProperty("AppClass");
                    } else {
                        midletClassName = properties.getProperty("MIDlet-1");
                        if (midletClassName != null) {
                            midletClassName = midletClassName.substring(midletClassName.lastIndexOf(",") + 1).trim();
                        }
                    }
                    break block36;
                }
                if (classPath == null) {
                    return false;
                }
                String[] stringArray = classPath.split(";");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    a.getLogStream().println("Get classes from " + stringArray[i2]);
                    Emulator.a(new File(stringArray[i2]), null);
                }
                Properties properties = null;
                if (jadPath != null && (file = new File(jadPath)).exists()) {
                    properties = new Properties();
                    properties.load(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    Enumeration<Object> enumeration = properties.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        properties.put(string, properties.getProperty(string));
                    }
                }
                if (properties == null) {
                    properties = new Properties();
                }
                a.setAppProperties(properties);
            }
            catch (Exception exception) {
                if (exception.toString().equalsIgnoreCase("java.io.IOException: Negative seek offset")) {
                    exception.printStackTrace();
                    a.getScreen().showMessage(s.a("LOAD_ZIP_ERROR", "Input file is not JAR or ZIP archive."), CustomMethod.getStackTrace(exception));
                    return false;
                }
                throw exception;
            }
        }
        return true;
    }

    private static void a(File file, String string) {
        string = string != null ? string + "." : "";
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string2 = string + fileArray[i2].getName();
            if (fileArray[i2].isDirectory()) {
                Emulator.a(fileArray[i2], string2);
                continue;
            }
            if (!string2.endsWith(".class")) continue;
            jarClasses.add(string2.substring(0, string2.length() - 6));
            a.getLogStream().println("Get class " + string2.substring(0, string2.length() - 6));
        }
    }

    public static File getFileFromClassPath(String string) {
        if (classPath == null) {
            return null;
        }
        String[] stringArray = classPath.split(";");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file = new File(stringArray[i2], string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static void setupMRUList() {
        String string;
        int n2;
        String[] stringArray;
        int n3;
        if (midletJar == null && Settings.recentJars[0].trim().equalsIgnoreCase("")) {
            return;
        }
        if (Settings.recentJars[0].trim().equalsIgnoreCase("")) {
            Settings.recentJars[0] = midletJar;
            return;
        }
        if (midletJar != null) {
            for (n3 = 4; n3 > 0; --n3) {
                if (!Settings.recentJars[n3].equalsIgnoreCase(Settings.recentJars[0])) continue;
                Settings.recentJars[n3] = Settings.recentJars[1];
                Settings.recentJars[1] = Settings.recentJars[0];
                if (!Settings.recentJars[0].equalsIgnoreCase(midletJar)) {
                    Settings.recentJars[0] = midletJar;
                }
                return;
            }
        }
        for (n3 = 4; n3 > 0; --n3) {
            if (!Settings.recentJars[n3].equalsIgnoreCase(Settings.recentJars[0])) continue;
            Settings.recentJars[n3] = Settings.recentJars[1];
            Settings.recentJars[1] = Settings.recentJars[0];
            break;
        }
        if (n3 == 0) {
            for (int i2 = 4; i2 > 0; --i2) {
                Settings.recentJars[i2] = Settings.recentJars[i2 - 1];
            }
        }
        if (midletJar == null) {
            stringArray = Settings.recentJars;
            n2 = 0;
            string = "";
        } else {
            stringArray = Settings.recentJars;
            n2 = 0;
            string = midletJar;
        }
        stringArray[n2] = string;
    }

    private static void b() {
        System.setProperty("microedition.configuration", "CLDC-1.1");
        System.setProperty("microedition.profiles", "MIDP-2.0");
        if (platform.c()) {
            System.setProperty("microedition.m3g.version", "1.1");
        }
        System.setProperty("microedition.encoding", AppSettings.fileEncoding);
        if (System.getProperty("microedition.locale") == null) {
            System.setProperty("microedition.locale", AppSettings.locale);
        }
        if (System.getProperty("microedition.platform") == null) {
            String string = AppSettings.microeditionPlatform;
            httpUserAgent = string + " (Java/" + System.getProperty("java.version") + "; KEmulator/" + version + ")";
            System.setProperty("microedition.platform", string);
            System.setProperty("device.model", string);
        }
        System.setProperty("microedition.media.version", "1.0");
        System.setProperty("supports.mixing", "true");
        System.setProperty("supports.audio.capture", "false");
        System.setProperty("supports.recording", "false");
        System.setProperty("microedition.io.file.FileConnection.version", "1.0");
        System.setProperty("microedition.pim.version", "1.0");
        System.setProperty("bluetooth.api.version", "1.0");
        if (System.getProperty("wireless.messaging.sms.smsc") == null) {
            System.setProperty("wireless.messaging.sms.smsc", "+8613800010000");
        }
        if (System.getProperty("wireless.messaging.mms.mmsc") == null) {
            System.setProperty("wireless.messaging.mms.mmsc", "http://mms.kemulator.com");
        }
        System.setProperty("microedition.sensor.version", "1.0");
        System.setProperty("kemulator.notificationapi.version", "1.0");
        System.setProperty("fileconn.dir.photos", "file:///root/photos/");
        System.setProperty("fileconn.dir.music", "file:///root/music/");
        System.setProperty("fileconn.dir.private", "file://root/private/");
        System.setProperty("fileconn.dir.memorycard", "file:///root/e/");
        System.setProperty("microedition.hostname", "localhost");
        if (System.getProperty("wireless.messaging.version") == null) {
            System.setProperty("wireless.messaging.version", "1.0");
        }
        System.setProperty("kemulator.mod.version", version);
        System.setProperty("kemulator.mod.versionint", "34");
        System.setProperty("com.nokia.mid.ui.softnotification", "true");
        System.setProperty("com.nokia.mid.ui.version", "1.4");
        System.setProperty("com.nokia.mid.ui.customfontsize", "true");
        System.setProperty("com.nokia.pointer.number", "0");
        System.setProperty("kemulator.hwid", Utils.a());
        System.setProperty("microedition.amms.version", "1.0");
        System.setProperty("org.pigler.api.version", "1.4-kemulator");
        if (platform.a()) {
            System.setProperty("kemulator.x64", "true");
        }
        System.setProperty("kemulator.rpc.version", "1.0");
        System.setProperty("ru.nnproject.symbiangl", "0.2-kemulator");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        try {
            platform = (k)Class.forName("emulator.e").newInstance();
        }
        catch (Exception exception) {
            System.out.println("Platform class not found");
            return;
        }
        try {
            object2 = new Manifest(Emulator.class.getResourceAsStream("/META-INF/version.mf"));
            object = ((Manifest)object2).getMainAttributes();
            for (Map.Entry<Object, Object> throwable : ((Attributes)object).entrySet()) {
                if (!throwable.getKey().toString().equals("Git-Revision")) continue;
                String string = throwable.getValue().toString();
                if (string.length() != 0) {
                    if (debugBuild) {
                        version = string;
                    }
                    revision = string;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = System.getProperty("os.arch");
        if (!(platform.a() || ((String)object2).contains("86") && Utils.win)) {
            JOptionPane.showMessageDialog(new JPanel(), "Can't run this version of KEmulator nnmod on this architecture (" + (String)object2 + "). Try multi-platform version instead.");
            System.exit(0);
            return;
        }
        try {
            void var3_14;
            object = null;
            try {
                platform.a();
            }
            catch (Exception exception) {
                object = exception;
            }
            aw.a();
            commandLineArguments = stringArray;
            s.a();
            for (String string : stringArray) {
                if ("-s".equals(string)) {
                    a = true;
                    continue;
                }
                if (!"-uei".equals(string)) continue;
                AppSettings.uei = true;
            }
            if (!a && !AppSettings.uei && (object != null || Utils.macos || Utils.isJava9())) {
                Emulator.loadGame(null, false);
                return;
            }
            if (object != null) {
                ((Throwable)object).printStackTrace();
                JOptionPane.showMessageDialog(new JPanel(), "Failed to load libraries: " + ((Throwable)object).getMessage());
                System.exit(0);
                return;
            }
            a = c ? new bD("/tmp/kem/", a != 0 ? a : 240, b != 0 ? b : 320) : new eP();
            Emulator.a(stringArray);
            if (platform.a()) {
                Settings.g3d = 1;
                Settings.micro3d = 1;
            }
            platform.b();
            emulator.a.a(true);
            a.getLogStream().stdout(Emulator.getCmdVersionString() + " Running on " + System.getProperty("os.name") + ' ' + System.getProperty("os.arch") + " (" + System.getProperty("os.version") + "), Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
            emulator.c.a(Settings.deviceFile);
            AppSettings.init();
            Emulator.setupMRUList();
            RichPresence.initRichPresence();
            if (Settings.autoUpdate == 0) {
                Settings.autoUpdate = b ? 2 : a.getScreen().showUpdateDialog(0);
            }
            a.start();
            if (midletClassName == null && midletJar == null) {
                a.getScreen().initScreen(AppSettings.screenWidth, AppSettings.screenHeight);
                a.getScreen().runEmpty();
                a.dispose();
                System.exit(0);
                return;
            }
            a = new o();
            Emulator.getLibraries();
            try {
                if (!Emulator.getJarClasses()) {
                    a.getScreen().showMessage(s.a("LOAD_CLASSES_ERROR", "Get Classes Failed!! Plz check the input jar or classpath."));
                    System.exit(1);
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                a.getScreen().showMessage(s.a("LOAD_CLASSES_ERROR", "Get Classes Failed!! Plz check the input jar or classpath."), CustomMethod.getStackTrace(exception));
                System.exit(1);
                return;
            }
            if (midletClassName == null) {
                a.getScreen().showMessage(s.a("LOAD_MIDLET_ERROR", "Can not find MIDlet class. Plz check jad or use -midlet param."));
                System.exit(1);
                return;
            }
            Object var3_12 = null;
            try {
                String string = Emulator.getEmulator().getAppProperty("MIDlet-Icon");
                if (string == null && (string = Emulator.getEmulator().getAppProperty("AppIcon")) != null) {
                    string = string.split(",")[0].trim();
                }
                if (string == null && (string = Emulator.getEmulator().getAppProperty("MIDlet-1")) != null) {
                    string = string.split(",")[1].trim();
                }
                if (string != null && !string.trim().isEmpty()) {
                    iconPath = string;
                    InputStream inputStream = ResourceManager.getResourceAsStream(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                AppSettings.softbankApi = a.getAppProperty("MIDxlet-API") != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AppSettings.load(false) == 0) {
                a.openAppSettings(true);
            }
            Emulator.c();
            a.getScreen().initScreen(AppSettings.screenWidth, AppSettings.screenHeight);
            a.getScreen().setWindowIcon((InputStream)var3_14);
            Emulator.b();
            if (a.getAppProperty("MIDlet-Name") != null) {
                RichPresence.rpcState = (AppSettings.uei ? "Debugging " : "Running ") + a.getAppProperty("MIDlet-Name");
                RichPresence.rpcDetails = AppSettings.uei ? "UEI" : new File(midletJar).getName();
                RichPresence.updatePresence();
            }
            if (doja) {
                a = new f();
                a = new IApplicationMIDlet(midletClassName.trim());
            } else {
                Emulator.getEmulator().getLogStream().stdout("Launch MIDlet class: " + midletClassName);
                try {
                    midletClassName = midletClassName.replace('/', '.');
                    a = Class.forName(midletClassName, true, customClassLoader);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    a.getScreen().showMessage(s.a("FAIL_LAUNCH_MIDLET", "Fail to launch the MIDlet class:") + " " + midletClassName, CustomMethod.getStackTrace(throwable));
                    System.exit(1);
                    return;
                }
                a = new f();
            }
            new Thread(new Emulator()).start();
            a.getScreen().runWithMidlet();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            a.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    private static void c() {
        String string = AppSettings.devicePreset;
        if (!emulator.c.a(string)) {
            emulator.c.a(emulator.c.a());
        }
        if (a != 0) {
            AppSettings.screenWidth = a;
        }
        if (b != 0) {
            AppSettings.screenHeight = b;
        }
        emulator.c.a();
        n.a();
    }

    static boolean a(String[] stringArray) {
        if (stringArray.length < 1) {
            return false;
        }
        if (stringArray.length == 1 && (stringArray[0].endsWith(".jar") || stringArray[0].endsWith(".jad")) || stringArray[0].endsWith(".jam")) {
            String string = stringArray[0];
            if (string.endsWith(".jar")) {
                try {
                    midletJar = new File(string).getCanonicalPath();
                }
                catch (Exception exception) {
                    midletJar = string;
                }
            } else {
                jadPath = string;
                midletJar = Emulator.a(string);
            }
            return true;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].trim();
            if (string.startsWith("-")) {
                string = string.substring(1).toLowerCase();
            } else if (string.endsWith(".jar") || string.endsWith(".jad") || string.endsWith(".jam")) {
                if (string.endsWith(".jar")) {
                    try {
                        midletJar = new File(string).getCanonicalPath();
                    }
                    catch (Exception exception) {
                        midletJar = string;
                    }
                } else {
                    jadPath = string;
                    midletJar = Emulator.a(string);
                }
            }
            String string2 = null;
            if (i2 < stringArray.length - 1) {
                string2 = stringArray[i2 + 1].trim();
                if (!string2.startsWith("-")) {
                    ++i2;
                } else {
                    string2 = null;
                }
            }
            if (string.equals("awt")) {
                Settings.g2d = 1;
                continue;
            }
            if (string.equals("swt")) {
                Settings.g2d = 0;
                continue;
            }
            if (string.equals("lwj")) {
                Settings.g3d = 1;
                continue;
            }
            if (string.equals("swerve")) {
                Settings.g3d = 0;
                continue;
            }
            if (string.equals("mascotgl")) {
                Settings.micro3d = 1;
                continue;
            }
            if (string.equals("mascotdll")) {
                Settings.micro3d = 0;
                continue;
            }
            if (string.equalsIgnoreCase("log")) {
                Settings.showLogFrame = true;
                continue;
            }
            if (string.equalsIgnoreCase("uei")) {
                AppSettings.uei = true;
                continue;
            }
            if (string.equalsIgnoreCase("s")) {
                a = true;
                continue;
            }
            if (string.equalsIgnoreCase("updated")) {
                b = true;
                continue;
            }
            if (string.equals("bridge")) {
                c = true;
                continue;
            }
            if (string.equals("xray")) {
                AppSettings.xrayView = true;
                AppSettings.xrayBuffer = true;
                continue;
            }
            if (string.equalsIgnoreCase("hide")) {
                Settings.hideEmulation = true;
                continue;
            }
            if (string2 == null) continue;
            if (string.equalsIgnoreCase("jar")) {
                try {
                    midletJar = new File(string2).getCanonicalPath();
                }
                catch (Exception exception) {
                    midletJar = string2;
                }
                continue;
            }
            if (string.equalsIgnoreCase("midlet")) {
                midletClassName = stringArray[i2];
                continue;
            }
            if (string.equalsIgnoreCase("cp")) {
                classPath = string2;
                continue;
            }
            if (string.equalsIgnoreCase("jad")) {
                jadPath = string2;
                continue;
            }
            if (string.equalsIgnoreCase("rec")) {
                Settings.recordedKeysFile = string2;
                Settings.playingRecordedKeys = new File(string2).exists();
                continue;
            }
            if (string.equalsIgnoreCase("fontname")) {
                Emulator.getEmulator().getProperty().setDefaultFontName(string2);
                continue;
            }
            if (string.equalsIgnoreCase("fontsmall")) {
                AppSettings.fontSmallSize = Integer.parseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("fontmedium")) {
                AppSettings.fontMediumSize = Integer.parseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("fontlarge")) {
                AppSettings.fontLargeSize = Integer.parseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("screen")) {
                String[] stringArray2 = string2.split("x");
                if (stringArray2.length != 2 || Integer.parseInt(stringArray2[0]) <= 0 || Integer.parseInt(stringArray2[1]) <= 0) continue;
                a = Integer.parseInt(stringArray2[0]);
                b = Integer.parseInt(stringArray2[1]);
                emulator.c.a();
                cA.c = -1;
                cA.d = -1;
                Settings.resizeMode = eO.c;
                continue;
            }
            if (string.equalsIgnoreCase("key")) {
                n.a(string2);
                continue;
            }
            if (string.equals("new-project")) {
                new em();
                j.b(string2);
                continue;
            }
            if (string.equals("restore")) {
                new em();
                j.a(string2);
                continue;
            }
            if (string.equals("convert")) {
                new em();
                j.c(string2);
                continue;
            }
            if (!string.equals("edit")) continue;
            new em();
            j.d(string2);
        }
        return true;
    }

    public static String getAbsoluteFile() {
        String string = System.getProperty("user.dir");
        if (new File(string, "KEmulator.jar").exists() || new File(string, "sensorsimulator.jar").exists()) {
            return string + File.separatorChar + "KEmulator.jar";
        }
        string = Emulator.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        if (Utils.win) {
            string = string.substring(1);
        }
        if (debugBuild && string.endsWith("/")) {
            if (string.endsWith("bin/production/KEmulator_base/")) {
                string = string.substring(0, string.length() - "bin/production/KEmulator_base/".length()) + "home";
            } else if (string.endsWith("eclipse/KEmulator_base/bin/")) {
                string = string.substring(0, string.length() - "eclipse/KEmulator_base/bin/".length()) + "home";
            }
            if (new File(string, "KEmulator.jar").exists() || new File(string, "sensorsimulator.jar").exists()) {
                string = string + File.separatorChar + "KEmulator.jar";
            } else {
                System.out.println("Running from " + string);
                throw new RuntimeException("Could not find home directory");
            }
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getAbsolutePath() {
        String string = System.getProperty("user.dir");
        if (new File(string, "KEmulator.jar").exists() || new File(string, "sensorsimulator.jar").exists()) {
            return string;
        }
        File file = new File(Emulator.getAbsoluteFile()).getParentFile();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    private static boolean b() {
        String string = Emulator.getAbsoluteFile();
        if (Files.exists(Paths.get(string, new String[0]), new LinkOption[0]) && !Files.isWritable(Paths.get(string, new String[0]))) {
            return false;
        }
        if (Utils.linux) {
            if (string.startsWith("/opt/") || string.startsWith("/usr/") || string.startsWith("/bin/")) {
                return false;
            }
            return !string.contains("/home/") || !string.contains("/.local/");
        }
        if (Utils.win) {
            try {
                String string2;
                String string3 = Utils.getProcessOutput(new String[]{"reg", "query", "HKEY_LOCAL_MACHINE\\Software\\nnproject\\KEmulator", "/v", "JarInstalledPath"}, false);
                int n2 = string3.indexOf("REG_SZ");
                if (n2 != -1 && Files.isSameFile(Paths.get(string2 = string3.substring(n2 + 6).trim(), new String[0]), Paths.get(string, new String[0]))) {
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return !string.contains("\\Users\\") || !string.contains("\\AppData\\Local\\");
        }
        return true;
    }

    public static String getUserPath() {
        block4: {
            String string;
            block6: {
                block5: {
                    if (isPortable) break block4;
                    if (!Utils.linux) break block5;
                    string = System.getenv("HOME") + "/.local/share/KEmulator/";
                    break block6;
                }
                if (!Utils.win || (string = System.getenv("APPDATA")) == null) break block4;
                string = string + "\\KEmulator";
            }
            Path path = Paths.get(string, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                return string;
            }
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                break block4;
            }
            return string;
        }
        return Emulator.getAbsolutePath();
    }

    public static void loadGame(String string, boolean bl2) {
        Emulator.loadGame(string, Settings.g2d, Settings.g3d, Settings.micro3d, bl2);
    }

    public static void loadGame(String string, int n2, int n3, int n4, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (a != null) {
            Emulator.getEmulator().getLogStream().println(string == null ? "Restarting" : "loadGame: " + string);
        } else {
            System.out.println(string == null ? "Restarting" : "loadGame: " + string);
        }
        String string2 = System.getProperty("java.home");
        arrayList.add(string2 == null || string2.length() < 1 ? "java" : string2 + (!Utils.win ? "/bin/java" : "/bin/java.exe"));
        arrayList.add("-cp");
        arrayList.add(System.getProperty("java.class.path"));
        arrayList.add("-Xmx" + Settings.xmx + "M");
        if (Settings.jdwpDebug) {
            arrayList.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=" + Settings.debugPort);
        }
        arrayList.add("-Djava.library.path=" + Emulator.getAbsolutePath());
        if ("false".equals(System.getProperty("sun.java3d.d3d"))) {
            arrayList.add("-Dsun.java3d.d3d=false");
        }
        if (Utils.os.startsWith("darwin") || Utils.os.startsWith("mac os")) {
            arrayList.add("-XstartOnFirstThread");
        }
        arrayList.add("-Dfile.encoding=UTF-8");
        if (debugBuild) {
            File file = new File(Emulator.getAbsolutePath() + "/../eclipse/KEmulator_base/agent.jar");
            if (file.exists()) {
                arrayList.add("-javaagent:" + file);
            } else {
                arrayList.add("-javaagent:" + Emulator.getAbsoluteFile());
            }
        } else {
            arrayList.add("-javaagent:" + Emulator.getAbsoluteFile());
        }
        if (Utils.isJava9()) {
            arrayList.add("--add-opens");
            arrayList.add("java.base/java.lang=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.base/java.lang.reflect=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.base/java.lang.ref=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.base/java.io=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.base/java.util=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("jdk.unsupported/sun.misc=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.desktop/com.sun.media.sound=ALL-UNNAMED");
            arrayList.add("--add-opens");
            arrayList.add("java.desktop/javax.sound.midi=ALL-UNNAMED");
            if (Utils.isJava17()) {
                arrayList.add("--enable-native-access=ALL-UNNAMED");
            }
        }
        arrayList.add("emulator.Emulator");
        if (string == null) {
            boolean bl3 = false;
            for (String string3 : commandLineArguments) {
                if (bl3) {
                    bl3 = false;
                    continue;
                }
                if (string3.equals("-screen")) {
                    bl3 = true;
                    continue;
                }
                if (string3.equals("-swt") || string3.equals("-awt") || string3.equals("-swerve") || string3.equals("-lwj") || string3.equals("-mascotdll") || string3.equals("-mascotgl") || string3.equals("-s") || string3.equals("-updated") || string3.equals("-uei")) continue;
                arrayList.add(string3);
            }
        } else if (string.toLowerCase().endsWith(".jad") || string.toLowerCase().endsWith(".jam")) {
            arrayList.add("-jad");
            arrayList.add(string);
            arrayList.add("-jar");
            arrayList.add(Emulator.a(string));
        } else {
            arrayList.add("-jar");
            arrayList.add(string);
        }
        if (Settings.recordedKeysFile != null) {
            arrayList.add("-rec");
            arrayList.add(Settings.recordedKeysFile);
        }
        arrayList.add(n2 == 0 ? "-swt" : "-awt");
        arrayList.add(n3 == 0 ? "-swerve" : "-lwj");
        arrayList.add(n4 == 0 ? "-mascotdll" : "-mascotgl");
        arrayList.add("-s");
        try {
            Emulator.getEmulator().disposeSubWindows();
            Emulator.notifyDestroyed();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).directory(new File(Emulator.getAbsolutePath())).command(arrayList).inheritIO();
            processBuilder.environment().remove("GDK_BACKEND");
            processBuilder.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CustomMethod.close();
        System.exit(0);
    }

    static String a(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                if (string.toLowerCase().endsWith(".jam")) {
                    return string.substring(0, string.length() - 3) + "jar";
                }
                Properties properties = new Properties();
                properties.load(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                return file.getParent() + File.separator + properties.getProperty("MIDlet-Jar-URL");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void AntiCrack(Exception exception) {
    }

    public static String getMidletName() {
        String string = a.getAppProperty("MIDlet-1").split(",")[0];
        if (string.startsWith(" ")) {
            string = string.substring(1);
        }
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static boolean isX64() {
        return platform.a();
    }

    public static k getPlatform() {
        return platform;
    }

    public static IGraphics3D getGraphics3D() {
        return platform.a();
    }

    @Override
    public void run() {
        if (!doja) {
            try {
                Emulator.setMIDlet((MIDlet)a.newInstance());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                a.a();
                a.getScreen().showMessageThreadSafe(s.a("FAIL_LAUNCH_MIDLET", "Fail to launch the MIDlet class:") + " " + midletClassName, CustomMethod.getStackTrace(throwable));
                return;
            }
        }
        if (Emulator.getEmulator() instanceof eP) {
            eP eP2 = (eP)Emulator.getEmulator();
            eP2.a().a();
            eP2.b().a();
        }
        a.d(10);
    }

    static /* synthetic */ boolean a() {
        return b;
    }

    static /* synthetic */ IEmulatorFrontend a() {
        return a;
    }

    static {
        version = "2.21";
        revision = "";
        isPortable = Emulator.b();
        customClassLoader = new b(ClassLoader.getSystemClassLoader());
        jarLibrarys = new Vector();
        jarClasses = new Vector();
        a = new Thread(new d());
    }
}

