/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Structure;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class WinBase$SYSTEMTIME
extends Structure {
    public short wYear;
    public short wMonth;
    public short wDayOfWeek;
    public short wDay;
    public short wHour;
    public short wMinute;
    public short wSecond;
    public short wMilliseconds;

    public WinBase$SYSTEMTIME() {
    }

    public WinBase$SYSTEMTIME(Date date) {
        this(date.getTime());
    }

    public WinBase$SYSTEMTIME(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        this.fromCalendar(calendar);
    }

    public WinBase$SYSTEMTIME(Calendar calendar) {
        this.fromCalendar(calendar);
    }

    public void fromCalendar(Calendar calendar) {
        this.wYear = (short)calendar.get(1);
        this.wMonth = (short)(1 + calendar.get(2) - 0);
        this.wDay = (short)calendar.get(5);
        this.wHour = (short)calendar.get(11);
        this.wMinute = (short)calendar.get(12);
        this.wSecond = (short)calendar.get(13);
        this.wMilliseconds = (short)calendar.get(14);
        this.wDayOfWeek = (short)(calendar.get(7) - 1);
    }

    public Calendar toCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.wYear);
        calendar.set(2, 0 + (this.wMonth - 1));
        calendar.set(5, this.wDay);
        calendar.set(11, this.wHour);
        calendar.set(12, this.wMinute);
        calendar.set(13, this.wSecond);
        calendar.set(14, this.wMilliseconds);
        return calendar;
    }

    @Override
    public String toString() {
        if (this.wYear == 0 && this.wMonth == 0 && this.wDay == 0 && this.wHour == 0 && this.wMinute == 0 && this.wSecond == 0 && this.wMilliseconds == 0) {
            return super.toString();
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Calendar calendar = this.toCalendar();
        return dateFormat.format(calendar.getTime());
    }
}

